/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.plugin.parameter;

import java.util.ArrayList;
import net.sf.tweety.plugin.parameter.CommandParameter;
import net.sf.tweety.plugin.parameter.StringListCommandParameter;

public class CustomStringListCommandParameter
extends StringListCommandParameter {
    private String[] value;
    private String criteria;

    public CustomStringListCommandParameter(String id, String des) {
        super(id, des);
    }

    public CustomStringListCommandParameter(String id, String des, String criteria) {
        super(id, des);
    }

    @Override
    public String[] getValue() {
        return this.value;
    }

    public String getCriteria() {
        return this.criteria;
    }

    @Override
    public void setValue(String[] value) {
        this.value = value;
    }

    public void setCriteria(String criteria) {
        this.criteria = criteria;
    }

    @Override
    public boolean isValid(String s) {
        return s.matches(this.criteria);
    }

    @Override
    public CommandParameter instantiate(String s) {
        if (this.isValid(s)) {
            String[] in = new String[]{s};
            StringListCommandParameter newParam = (StringListCommandParameter)this.clone();
            newParam.setValue(in);
            return newParam;
        }
        throw new IllegalArgumentException("No valid instantiation parameter: " + s);
    }

    @Override
    public CommandParameter instantiate(String[] s) {
        ArrayList<String> als = new ArrayList<String>();
        for (int i = 0; i < s.length; ++i) {
            if (!this.isValid(s[i])) continue;
            als.add(s[i]);
        }
        StringListCommandParameter newParam = (StringListCommandParameter)this.clone();
        newParam.setValue((String[])als.toArray());
        return newParam;
    }

    @Override
    public Object clone() {
        return new CustomStringListCommandParameter(this.getIdentifier(), this.getDescription(), this.getCriteria());
    }
}

