/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.plugin.parameter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.tweety.plugin.parameter.CommandParameter;

public class FileListCommandParameter
extends CommandParameter {
    private File[] value;

    public FileListCommandParameter(String id, String des) {
        super(id, des);
    }

    public File[] getValue() {
        return this.value;
    }

    public void setValue(File[] value) {
        this.value = value;
    }

    @Override
    public boolean isValid(String s) {
        File tmp = new File(s);
        try {
            tmp.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tmp.exists() && tmp.isFile() && tmp.canWrite() && tmp.canRead();
    }

    @Override
    public CommandParameter instantiate(String filename) {
        File[] out = new File[1];
        if (this.isValid(filename)) {
            out[0] = new File(filename.toString()).getAbsoluteFile();
        }
        FileListCommandParameter file = (FileListCommandParameter)this.clone();
        file.setValue(out);
        return file;
    }

    public CommandParameter instantiate(ArrayList<String> a) {
        File[] out = new File[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            if (!this.isValid(a.get(i))) continue;
            out[i] = new File(a.get(i).toString()).getAbsoluteFile();
        }
        FileListCommandParameter filelist = (FileListCommandParameter)this.clone();
        filelist.setValue(out);
        return filelist;
    }

    public Object clone() {
        return new FileListCommandParameter(this.getIdentifier(), this.getDescription());
    }
}

