/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tweety.plugin.parameter;

import net.sf.tweety.math.Interval;
import net.sf.tweety.plugin.parameter.CommandParameter;

public class IntegerCommandParameter
extends CommandParameter {
    private Interval<Integer> interval;
    private Integer value;

    public IntegerCommandParameter(String id, String des) {
        super(id, des);
    }

    public IntegerCommandParameter(String id, String des, Interval<Integer> interval) {
        super(id, des);
        this.interval = interval;
    }

    public IntegerCommandParameter(String id, String des, String interval) {
        super(id, des);
        this.setInterval(interval);
    }

    public void setInterval(String interval) {
    }

    public Interval<Integer> getInterval() {
        return this.interval;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public boolean isValid(String s) {
        Integer in = Integer.parseInt(s);
        return in >= (Integer)this.interval.getLowerBound() && in <= (Integer)this.interval.getUpperBound();
    }

    @Override
    public CommandParameter instantiate(String s) {
        if (this.isValid(s)) {
            IntegerCommandParameter newParameter = (IntegerCommandParameter)this.clone();
            newParameter.setValue(Integer.parseInt(s));
            return newParameter;
        }
        return null;
    }

    public Object clone() {
        return new IntegerCommandParameter(this.getIdentifier(), this.getDescription(), this.getInterval());
    }
}

