/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;

public class AnnotationParameterNameDiscoverer
extends DefaultParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private final Logger log = LoggerFactory.getLogger(AnnotationParameterNameDiscoverer.class);

    @Nullable
    public String[] getParameterNames(Method method) {
        return super.getParameterNames(method);
    }

    @Nullable
    private String getMyAnnotation(Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!(a instanceof ParameterName)) continue;
            ParameterName param = (ParameterName)a;
            return param.name();
        }
        return null;
    }

    public String[] getParameterNames(Constructor<?> ctor) {
        boolean isOurs;
        Annotation[][] annotationsArray = ctor.getParameterAnnotations();
        if (annotationsArray.length == 0) {
            return super.getParameterNames(ctor);
        }
        String className = ctor.getDeclaringClass().getName();
        boolean bl = isOurs = className != null && (className.startsWith("org.opensaml") || className.startsWith("net.shibboleth"));
        if (!isOurs) {
            return super.getParameterNames(ctor);
        }
        boolean allPresent = true;
        String[] names = new String[annotationsArray.length];
        for (int index = 0; index < annotationsArray.length; ++index) {
            names[index] = this.getMyAnnotation(annotationsArray[index]);
            if (names[index] != null) continue;
            allPresent = false;
        }
        if (!allPresent) {
            this.log.debug("Constructor for class '{}' with {} parameters: Not all parameters are annotated with @ParameterName", (Object)className, (Object)annotationsArray.length);
            this.log.debug("Types : {}", ctor.getParameterTypes());
            return super.getParameterNames(ctor);
        }
        this.log.trace("Constructor for class '{}' with {} parameters called {}", new Object[]{className, names.length, names});
        return names;
    }
}

