/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.service;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.service.ReloadableTestBean;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonReloadableTestBean
extends AbstractInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(NonReloadableTestBean.class);
    @Nonnull
    @NotEmpty
    private final String id;
    @Nullable
    private ReloadableTestBean child;

    public NonReloadableTestBean(@Nonnull @NotEmpty String name) {
        this.id = name;
        this.log.debug("NonReloadableTestBean {} created", (Object)this.id);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.log.debug("NonReloadableTestBean {} initialized", (Object)this.id);
    }

    protected void doDestroy() {
        this.log.debug("NonReloadableTestBean {} destroyed", (Object)this.id);
        super.doDestroy();
    }

    public ReloadableTestBean getChild() {
        this.log.debug("NonReloadableTestBean {} child getter called", (Object)this.id);
        return this.child;
    }

    public void setChild(ReloadableTestBean b) {
        this.child = b;
    }

    public int getValue() {
        return this.getChild().getValue();
    }
}

