/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resource.Resource;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;

@Deprecated
public class SVNResource
extends AbstractIdentifiedInitializableComponent
implements org.springframework.core.io.Resource,
BeanNameAware,
InitializingBean,
Resource {
    private final Logger log = LoggerFactory.getLogger(SVNResource.class);
    @Nonnull
    private final SVNClientManager clientManager;
    @Nonnull
    private SVNURL remoteRepository;
    @Nonnull
    private File workingCopyDirectory;
    private SVNRevision retrievalRevision;
    private String resourceFileName;
    private DateTime lastModified;

    public SVNResource(@Nonnull @ParameterName(name="svnClientMgr") SVNClientManager svnClientMgr, @Nonnull @ParameterName(name="repositoryUrl") SVNURL repositoryUrl, @Nonnull @ParameterName(name="workingCopy") File workingCopy, @ParameterName(name="workingRevision") long workingRevision, @Nonnull @ParameterName(name="resourceFile") String resourceFile) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CLASS, (String)SVNResource.class.getName(), null, null);
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (svnClientMgr == null) {
            this.log.error("SVN client manager may not be null");
            throw new BeanCreationException("SVN client manager may not be null");
        }
        this.clientManager = svnClientMgr;
        if (repositoryUrl == null) {
            throw new BeanCreationException("SVN repository URL may not be null");
        }
        this.remoteRepository = repositoryUrl;
        try {
            this.checkWorkingCopyDirectory(workingCopy);
            this.workingCopyDirectory = workingCopy;
        }
        catch (IOException e) {
            throw new BeanCreationException(e.getMessage());
        }
        this.retrievalRevision = workingRevision < 0L ? SVNRevision.HEAD : SVNRevision.create((long)workingRevision);
        this.setFilename(resourceFile);
        try {
            this.checkoutOrUpdateResource();
            if (!this.getFile().exists()) {
                this.log.error("Resource file " + resourceFile + " does not exist in SVN working copy directory " + workingCopy.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new BeanCreationException(e.getMessage());
        }
    }

    public String getFilename() {
        return this.resourceFileName;
    }

    public void setFilename(@Nonnull String fileName) {
        this.resourceFileName = StringSupport.trimOrNull((String)fileName);
        if (this.resourceFileName == null) {
            this.log.error("SVN working copy resource file name may not be null or empty");
            throw new BeanCreationException("SVN working copy resource file name may not be null or empty");
        }
    }

    protected String getFullPath() {
        StringBuffer buffer = new StringBuffer(this.remoteRepository.getPath().length() + 1 + this.getFilename().length());
        buffer.append(this.remoteRepository.getPath()).append('/').append(this.getFilename());
        return buffer.toString();
    }

    protected String getProtocol() {
        StringBuffer buffer = new StringBuffer(4 + this.remoteRepository.getProtocol().length());
        buffer.append("svn+").append(this.remoteRepository.getProtocol());
        return buffer.toString();
    }

    protected void checkWorkingCopyDirectory(@Nonnull File directory) throws IOException {
        boolean created;
        if (directory == null) {
            this.log.error("SVN working copy directory cannot be null");
            throw new IOException("SVN working copy directory cannot be null");
        }
        if (!directory.exists() && !(created = directory.mkdirs())) {
            String msg = "SVN working copy directory " + directory.getAbsolutePath() + " does not exist and could not be created";
            this.log.error(msg);
            throw new IOException(msg);
        }
        if (!directory.isDirectory()) {
            String msg = "SVN working copy location " + directory.getAbsolutePath() + " is not a directory";
            this.log.error(msg);
            throw new IOException(msg);
        }
        if (!directory.canRead()) {
            String msg = "SVN working copy directory " + directory.getAbsolutePath() + " cannot be read by this process";
            this.log.error(msg);
            throw new IOException(msg);
        }
        if (!directory.canWrite()) {
            String msg = "SVN working copy directory " + directory.getAbsolutePath() + " cannot be written to by this process";
            this.log.error(msg);
            throw new IOException(msg);
        }
    }

    protected void checkoutOrUpdateResource() throws IOException {
        SVNRevision newRevision;
        this.log.debug("checking out or updating working copy");
        if (!this.workingCopyDirectoryExists()) {
            this.log.debug("Working copy does not yet exist, checking it out to {}", (Object)this.workingCopyDirectory.getAbsolutePath());
            newRevision = this.checkoutResourceDirectory();
        } else {
            if (this.retrievalRevision != SVNRevision.HEAD) {
                this.lastModified = this.getLastModificationForRevision(SVNRevision.HEAD);
                this.log.debug("Working copy exists and version is pegged at {}, no need to update", (Object)this.retrievalRevision.toString());
                return;
            }
            this.log.debug("Working copy exists, updating to latest version.");
            newRevision = this.updateResourceDirectory();
        }
        if (this.getFile().exists()) {
            this.log.debug("Determining last modification date of revision {}", (Object)newRevision.getNumber());
            this.lastModified = this.getLastModificationForRevision(newRevision);
        }
    }

    private boolean workingCopyDirectoryExists() {
        File svnMetadataDir = new File(this.workingCopyDirectory, ".svn");
        return svnMetadataDir.exists();
    }

    private SVNRevision checkoutResourceDirectory() throws IOException {
        try {
            long newRevision = this.clientManager.getUpdateClient().doCheckout(this.remoteRepository, this.workingCopyDirectory, this.retrievalRevision, this.retrievalRevision, SVNDepth.INFINITY, true);
            this.log.debug("Checked out revision {} from remote repository {} and stored it in local working directory {}", new Object[]{newRevision, this.remoteRepository.toDecodedString(), this.workingCopyDirectory.getAbsolutePath()});
            return SVNRevision.create((long)newRevision);
        }
        catch (SVNException e) {
            String errMsg = "Unable to check out revsion " + this.retrievalRevision.toString() + " from remote repository " + this.remoteRepository.toDecodedString() + " to local working directory " + this.workingCopyDirectory.getAbsolutePath();
            this.log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
    }

    private DateTime getLastModificationForRevision(SVNRevision revision) throws IOException {
        try {
            SVNStatusHandler handler = new SVNStatusHandler();
            this.clientManager.getStatusClient().doStatus(this.getFile(), revision, SVNDepth.INFINITY, true, true, false, false, (ISVNStatusHandler)handler, null);
            SVNStatus status = handler.getStatus();
            return new DateTime((Object)status.getCommittedDate());
        }
        catch (SVNException e) {
            String errMsg = "Unable to check status of resource " + this.resourceFileName + " within working directory " + this.workingCopyDirectory.getAbsolutePath();
            this.log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
    }

    private SVNRevision updateResourceDirectory() throws IOException {
        try {
            long newRevision = this.clientManager.getUpdateClient().doUpdate(this.workingCopyDirectory, this.retrievalRevision, SVNDepth.INFINITY, true, true);
            this.log.debug("Updated local working directory {} to revision {} from remote repository {}", new Object[]{this.workingCopyDirectory.getAbsolutePath(), newRevision, this.remoteRepository.toDecodedString()});
            return SVNRevision.create((long)newRevision);
        }
        catch (SVNException e) {
            String errMsg = "Unable to update working copy of resoure " + this.remoteRepository.toDecodedString() + " in working copy " + this.workingCopyDirectory.getAbsolutePath() + " to revsion " + this.retrievalRevision.toString();
            this.log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
    }

    public InputStream getInputStream() throws IOException {
        this.checkoutOrUpdateResource();
        try {
            return new FileInputStream(this.getFile());
        }
        catch (IOException e) {
            this.log.error("Unable to read resource file {} from local working copy {}", new Object[]{this.resourceFileName, this.workingCopyDirectory.getAbsolutePath(), e});
            throw e;
        }
    }

    public boolean exists() {
        try {
            this.checkoutOrUpdateResource();
            return this.getFile().exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isReadable() {
        return this.exists();
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException {
        return new URL(this.getProtocol(), this.remoteRepository.getHost(), this.remoteRepository.getPort(), this.getFullPath());
    }

    public URI getURI() throws IOException {
        try {
            return new URI(this.getProtocol(), null, this.remoteRepository.getHost(), this.remoteRepository.getPort(), this.getFullPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public File getFile() throws IOException {
        return new File(this.workingCopyDirectory, this.resourceFileName);
    }

    public long contentLength() throws IOException {
        return this.getFile().getTotalSpace();
    }

    public long lastModified() throws IOException {
        this.checkoutOrUpdateResource();
        return this.lastModified.getMillis();
    }

    public org.springframework.core.io.Resource createRelative(String relativePath) throws IOException {
        throw new IOException("Cannot support relative open on SVN resources");
    }

    public Resource createRelativeResource(String relativePath) throws IOException {
        throw new IOException("Cannot support relative open on SVN resources");
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer("SVN Resource: ");
        return sb.append(this.getFullPath()).toString();
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    public void setBeanName(String name) {
        if (!this.isInitialized()) {
            this.setId(name);
        }
    }

    private class SVNStatusHandler
    implements ISVNStatusHandler {
        private SVNStatus status;

        private SVNStatusHandler() {
        }

        public SVNStatus getStatus() {
            return this.status;
        }

        public void handleStatus(SVNStatus currentStatus) throws SVNException {
            this.status = currentStatus;
        }
    }
}

