/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.component;

import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractIdentifiedInitializableComponentTest {
    @Test
    public void testId() throws Exception {
        MockComponent component = new MockComponent();
        Assert.assertNull((Object)component.getId());
        try {
            component.setId(null);
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            component.setId("");
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            component.setId("  ");
            Assert.fail();
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        component.setId(" foo ");
        Assert.assertEquals((String)component.getId(), (String)"foo");
        component.initialize();
        Assert.assertEquals((String)component.getId(), (String)"foo");
        try {
            component.setId("bar");
            Assert.fail();
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
    }

    @Test
    public void testInitialization() throws Exception {
        MockComponent component = new MockComponent();
        Assert.assertFalse((boolean)component.isInitialized());
        try {
            component.initialize();
            Assert.fail((String)"Initialized without an ID");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        component.setId("foo");
        component.initialize();
    }

    private class MockComponent
    extends AbstractIdentifiedInitializableComponent {
        private MockComponent() {
        }
    }
}

