/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.shibboleth.utilities.java.support.httpclient.ContextHandlingHttpClient;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpClientBuilderTest {
    @Test
    public void JSPT66() throws Exception {
        HttpClientBuilder builder = new HttpClientBuilder();
        Assert.assertEquals((int)builder.getConnectionTimeout(), (int)60000);
        Assert.assertEquals((int)builder.getSocketTimeout(), (int)60000);
        Assert.assertEquals((int)builder.getConnectionRequestTimeout(), (int)60000);
        HttpClient client = builder.buildClient();
        Assert.assertNotNull((Object)client);
    }

    @Test
    public void testContextHandlingSupport() throws Exception {
        TestContextHandler handler1 = new TestContextHandler();
        TestContextHandler handler2 = new TestContextHandler();
        TestContextHandler handler3 = new TestContextHandler();
        HttpClientBuilder builder = new HttpClientBuilder();
        Assert.assertNotNull((Object)builder.getStaticContextHandlers());
        Assert.assertTrue((boolean)builder.getStaticContextHandlers().isEmpty());
        builder.setStaticContextHandlers((List)Lists.newArrayList((Object[])new HttpClientContextHandler[]{null, handler1, null, handler2, null, handler3}));
        Assert.assertEquals((Collection)builder.getStaticContextHandlers(), (Collection)Lists.newArrayList((Object[])new HttpClientContextHandler[]{handler1, handler2, handler3}));
        try {
            builder.getStaticContextHandlers().add(new TestContextHandler());
            Assert.fail((String)"List should have been unmodifaible");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        builder.resetDefaults();
        Assert.assertNotNull((Object)builder.getStaticContextHandlers());
        Assert.assertTrue((boolean)builder.getStaticContextHandlers().isEmpty());
        HttpClient client = builder.buildClient();
        Assert.assertNotNull((Object)client);
        Assert.assertTrue((boolean)ContextHandlingHttpClient.class.isInstance(client));
    }

    public class TestContextHandler
    implements HttpClientContextHandler {
        public void invokeBefore(HttpClientContext context, HttpUriRequest request) throws IOException {
        }

        public void invokeAfter(HttpClientContext context, HttpUriRequest request) throws IOException {
        }
    }
}

