/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.CookieManager;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CookieManagerTest {
    @Test
    public void testInitFailure() {
        CookieManager cm = new CookieManager();
        try {
            cm.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testInitSuccess() throws ComponentInitializationException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        CookieManager cm = new CookieManager();
        cm.setHttpServletRequest((HttpServletRequest)request);
        cm.setHttpServletResponse((HttpServletResponse)response);
        cm.initialize();
    }

    @Test
    public void testCookieWithPath() throws ComponentInitializationException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        CookieManager cm = new CookieManager();
        cm.setHttpServletRequest((HttpServletRequest)request);
        cm.setHttpServletResponse((HttpServletResponse)response);
        cm.setCookiePath("/idp");
        cm.initialize();
        cm.addCookie("foo", "bar");
        Cookie cookie = response.getCookie("foo");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((String)cookie.getValue(), (String)"bar");
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((int)cookie.getMaxAge(), (int)-1);
    }

    @Test
    public void testCookieNoPath() throws ComponentInitializationException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/idp");
        MockHttpServletResponse response = new MockHttpServletResponse();
        CookieManager cm = new CookieManager();
        cm.setHttpServletRequest((HttpServletRequest)request);
        cm.setHttpServletResponse((HttpServletResponse)response);
        cm.initialize();
        cm.addCookie("foo", "bar");
        Cookie cookie = response.getCookie("foo");
        Assert.assertNotNull((Object)cookie);
        Assert.assertEquals((String)cookie.getValue(), (String)"bar");
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((int)cookie.getMaxAge(), (int)-1);
    }

    @Test
    public void testCookieUnset() throws ComponentInitializationException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/idp");
        request.setCookies(new Cookie[]{new Cookie("foo", "bar")});
        MockHttpServletResponse response = new MockHttpServletResponse();
        CookieManager cm = new CookieManager();
        cm.setHttpServletRequest((HttpServletRequest)request);
        cm.setHttpServletResponse((HttpServletResponse)response);
        cm.initialize();
        cm.unsetCookie("foo");
        Cookie cookie = response.getCookie("foo");
        Assert.assertNotNull((Object)cookie);
        Assert.assertNull((Object)cookie.getValue());
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((int)cookie.getMaxAge(), (int)0);
    }
}

