/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.net.URISupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class URISupportTest {
    @Test
    public void testBuildQuery() {
    }

    @Test
    public void testSetFragment() {
    }

    @Test
    public void testSetHost() {
    }

    @Test
    public void testSetPath() {
    }

    @Test
    public void testSetPort() {
    }

    @Test
    public void testSetQuery() {
    }

    @Test
    public void testSetScheme() {
    }

    @Test
    public void testTrimOrNullFragment() {
    }

    @Test
    public void testTrimOrNullPath() {
    }

    @Test
    public void testTrimOrNullQuery() {
    }

    @Test
    public void testBuildQueryMap() {
        Map map = null;
        map = URISupport.buildQueryMap(null);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.isEmpty());
        map = URISupport.buildQueryMap(Collections.emptyList());
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.isEmpty());
        ArrayList<Pair> params = new ArrayList<Pair>();
        params.add(new Pair((Object)"one", (Object)"1"));
        params.add(new Pair((Object)"two", (Object)"2"));
        params.add(new Pair((Object)"three", (Object)"3"));
        map = URISupport.buildQueryMap(params);
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((int)map.size(), (int)3);
        Assert.assertTrue((boolean)map.containsKey("one"));
        Assert.assertEquals((String)((String)map.get("one")), (String)"1");
        Assert.assertTrue((boolean)map.containsKey("two"));
        Assert.assertEquals((String)((String)map.get("two")), (String)"2");
        Assert.assertTrue((boolean)map.containsKey("three"));
        Assert.assertEquals((String)((String)map.get("three")), (String)"3");
    }

    @Test
    public void testGetRawQueryStringParameter() {
        String param = URISupport.getRawQueryStringParameter(null, null);
        Assert.assertEquals((String)param, null);
        param = URISupport.getRawQueryStringParameter((String)"", null);
        Assert.assertEquals((String)param, null);
        param = URISupport.getRawQueryStringParameter((String)"", (String)"");
        Assert.assertEquals((String)param, null);
        param = URISupport.getRawQueryStringParameter((String)"foo", null);
        Assert.assertEquals((String)param, null);
        param = URISupport.getRawQueryStringParameter((String)"foo", (String)"");
        Assert.assertEquals((String)param, null);
        String queryString = "paramName1=paramValue1&paramName%3D=paramValue%26&paramName2";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"paramName1");
        Assert.assertEquals((String)param, (String)"paramName1=paramValue1");
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"paramName=");
        Assert.assertEquals((String)param, (String)"paramName%3D=paramValue%26");
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"paramName2");
        Assert.assertEquals((String)param, (String)"paramName2");
        queryString = "?paramName1=paramValue1&paramName%3D=paramValue%26&paramName2#";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"paramName1");
        Assert.assertEquals((String)param, (String)"paramName1=paramValue1");
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"paramName=");
        Assert.assertEquals((String)param, (String)"paramName%3D=paramValue%26");
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"paramName2");
        Assert.assertEquals((String)param, (String)"paramName2");
        queryString = "ABC=123&Foo=Bar&XYZ=456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=Bar");
        queryString = "Foo=Bar&XYZ=456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=Bar");
        queryString = "ABC=123&Foo=Bar";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=Bar");
        queryString = "Foo=Bar";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=Bar");
        queryString = "ABC=123&Foo=Bar&XYZ456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"NotThere");
        Assert.assertNull((Object)param);
        queryString = "ABC=123&XYZ456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertNull((Object)param);
        queryString = null;
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertNull((Object)param);
        queryString = "ABC=123&FooFoo=BarBar&Foo=Bar&XYZ=456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=Bar");
        queryString = "ABC=123&Foo=&XYZ=456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=");
        queryString = "Foo=&ABC=123&XYZ=456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=");
        queryString = "ABC=123&XYZ=456&Foo=";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=");
        queryString = "ABC=123&Foo&XYZ=456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo");
        queryString = "Foo&ABC=123&XYZ=456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo");
        queryString = "ABC=123&XYZ=456&Foo";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo");
        queryString = "ABC=123&&Foo=Bar&XYZ456";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=Bar");
        queryString = "Foo";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo");
        queryString = "Foo=";
        param = URISupport.getRawQueryStringParameter((String)queryString, (String)"Foo");
        Assert.assertEquals((String)param, (String)"Foo=");
    }

    @Test
    public void testParseQueryString() {
        List params = URISupport.parseQueryString(null);
        Assert.assertTrue((boolean)params.isEmpty());
        params = URISupport.parseQueryString((String)"");
        Assert.assertTrue((boolean)params.isEmpty());
        String queryString = "paramName1=paramValue1&paramName%3D=paramValue%26&paramName2";
        params = URISupport.parseQueryString((String)queryString);
        Assert.assertTrue((boolean)params.contains(new Pair((Object)"paramName1", (Object)"paramValue1")));
        Assert.assertTrue((boolean)params.contains(new Pair((Object)"paramName=", (Object)"paramValue&")));
        Assert.assertTrue((boolean)params.contains(new Pair((Object)"paramName2", null)));
        queryString = "?paramName1=paramValue1&paramName%3D=paramValue%26&paramName2#";
        params = URISupport.parseQueryString((String)queryString);
        Assert.assertTrue((boolean)params.contains(new Pair((Object)"paramName1", (Object)"paramValue1")));
        Assert.assertTrue((boolean)params.contains(new Pair((Object)"paramName=", (Object)"paramValue&")));
        Assert.assertTrue((boolean)params.contains(new Pair((Object)"paramName2", null)));
    }
}

