/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.validation.Schema;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.SchemaBuilder;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BasicParserPoolTest {
    private static final String TEST_DIR = "/net/shibboleth/utilities/java/support/xml/";
    private static final String SCHEMA_FILE = "/net/shibboleth/utilities/java/support/xml/basicParserPoolTest.xsd";
    private static final String XML_FILE = "/net/shibboleth/utilities/java/support/xml/basicParserPoolTest.xml";
    private static final String DTD_FILE = "/net/shibboleth/utilities/java/support/xml/dtdParserPoolTest.xml";
    private BasicParserPool basicParserPool;
    int maxPoolSize = 10;

    @BeforeMethod
    public void setupEachTest() {
        this.basicParserPool = new BasicParserPool();
        this.basicParserPool.setMaxPoolSize(this.maxPoolSize);
    }

    @Test
    public void testParams() throws SAXException, ComponentInitializationException, XMLParserException, IOException {
        HashMap<String, Comparable<Boolean>> attributes = new HashMap<String, Comparable<Boolean>>();
        attributes.put("http://apache.org/xml/features/dom/create-entity-ref-nodes", Boolean.valueOf(false));
        attributes.put("http://apache.org/xml/properties/input-buffer-size", Integer.valueOf(2000));
        HashMap baseAttributes = new HashMap(attributes);
        attributes.put(null, Integer.valueOf(99));
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        features.put("http://xml.org/sax/features/use-entity-resolver2", false);
        HashMap baseFeatures = new HashMap(features);
        attributes.put(null, Boolean.valueOf(true));
        this.basicParserPool.setBuilderAttributes(attributes);
        this.basicParserPool.setBuilderFeatures(features);
        this.basicParserPool.setCoalescing(true);
        this.basicParserPool.setDTDValidating(true);
        this.basicParserPool.setExpandEntityReferences(true);
        this.basicParserPool.setIgnoreComments(true);
        this.basicParserPool.setIgnoreElementContentWhitespace(true);
        this.basicParserPool.setNamespaceAware(true);
        ClassPathResource r = new ClassPathResource(SCHEMA_FILE);
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addSchema(r.getInputStream());
        Schema schema = schemaBuilder.buildSchema();
        this.basicParserPool.setSchema(schema);
        this.basicParserPool.setXincludeAware(true);
        MockEntityResolver entityResolver = new MockEntityResolver();
        this.basicParserPool.setEntityResolver((EntityResolver)entityResolver);
        MockErrorHandler errorHandler = new MockErrorHandler();
        this.basicParserPool.setErrorHandler((ErrorHandler)errorHandler);
        this.basicParserPool.initialize();
        Assert.assertEquals((Object)this.basicParserPool.getBuilderAttributes(), baseAttributes, (String)"Checking attributes");
        attributes.clear();
        attributes.putAll(baseAttributes);
        attributes.put("foo", Integer.valueOf(99));
        Assert.assertNotSame((Object)this.basicParserPool.getBuilderAttributes(), baseAttributes, (String)"Checking attributes");
        Assert.assertEquals((Object)this.basicParserPool.getBuilderFeatures(), baseFeatures, (String)"Checking features");
        features.clear();
        features.putAll(baseFeatures);
        features.put("foo", false);
        Assert.assertNotSame((Object)this.basicParserPool.getBuilderAttributes(), baseFeatures, (String)"Checking features");
        Assert.assertTrue((boolean)this.basicParserPool.isCoalescing(), (String)"pool Coalescing");
        DocumentBuilder builder = this.basicParserPool.getBuilder();
        Assert.assertTrue((boolean)this.basicParserPool.isDTDValidating(), (String)"pool isDTDValidating");
        Assert.assertTrue((boolean)builder.isValidating(), (String)"builder Validating");
        Assert.assertTrue((boolean)this.basicParserPool.isExpandEntityReferences(), (String)"pool isExpandEntityReferences");
        Assert.assertTrue((boolean)this.basicParserPool.isIgnoreComments(), (String)"pool isIgnoreComments");
        Assert.assertTrue((boolean)this.basicParserPool.isIgnoreElementContentWhitespace(), (String)"pool isIgnoreElementContentWhitespace");
        Assert.assertTrue((boolean)builder.isNamespaceAware(), (String)"builder NameSpaceAware");
        Assert.assertTrue((boolean)this.basicParserPool.isNamespaceAware(), (String)"pool NameSpaceAware");
        Assert.assertEquals((Object)builder.getSchema(), (Object)schema, (String)"builder schema");
        Assert.assertEquals((Object)this.basicParserPool.getSchema(), (Object)schema, (String)"pool schema");
        Assert.assertTrue((boolean)builder.isXIncludeAware(), (String)"builder isXIncludeAware");
        Assert.assertTrue((boolean)this.basicParserPool.isXincludeAware(), (String)"pool isXIncludeAware");
        Assert.assertSame((Object)this.basicParserPool.getEntityResolver(), (Object)entityResolver);
        Assert.assertSame((Object)this.basicParserPool.getErrorHandler(), (Object)errorHandler);
        this.basicParserPool = new BasicParserPool();
        this.basicParserPool.setCoalescing(false);
        this.basicParserPool.setDTDValidating(false);
        this.basicParserPool.setExpandEntityReferences(false);
        this.basicParserPool.setIgnoreComments(false);
        this.basicParserPool.setIgnoreElementContentWhitespace(false);
        this.basicParserPool.setNamespaceAware(false);
        this.basicParserPool.setSchema(null);
        this.basicParserPool.setXincludeAware(false);
        this.basicParserPool.setEntityResolver(null);
        try {
            this.basicParserPool.setErrorHandler(null);
            Assert.fail((String)"Null ErrorHandler should have been rejected");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        this.basicParserPool.initialize();
        Assert.assertTrue((boolean)this.basicParserPool.getBuilderAttributes().isEmpty(), (String)"Checking attributes");
        Assert.assertFalse((boolean)this.basicParserPool.getBuilderFeatures().isEmpty(), (String)"Checking features");
        Assert.assertFalse((boolean)this.basicParserPool.isCoalescing(), (String)"pool Coalescing");
        builder = this.basicParserPool.getBuilder();
        Assert.assertFalse((boolean)this.basicParserPool.isDTDValidating(), (String)"pool isDTDValidating");
        Assert.assertFalse((boolean)builder.isValidating(), (String)"builder Validating");
        Assert.assertFalse((boolean)this.basicParserPool.isExpandEntityReferences(), (String)"pool isExpandEntityReferences");
        Assert.assertFalse((boolean)this.basicParserPool.isIgnoreComments(), (String)"pool isIgnoreComments");
        Assert.assertFalse((boolean)this.basicParserPool.isIgnoreElementContentWhitespace(), (String)"pool isIgnoreElementContentWhitespace");
        Assert.assertFalse((boolean)builder.isNamespaceAware(), (String)"builder NameSpaceAware");
        Assert.assertFalse((boolean)this.basicParserPool.isNamespaceAware(), (String)"pool NameSpaceAware");
        Assert.assertNull((Object)builder.getSchema(), (String)"builder schema");
        Assert.assertNull((Object)this.basicParserPool.getSchema(), (String)"pool schema");
        Assert.assertFalse((boolean)builder.isXIncludeAware(), (String)"builder isXIncludeAware");
        Assert.assertFalse((boolean)this.basicParserPool.isXincludeAware(), (String)"pool isXIncludeAware");
        Assert.assertNull((Object)this.basicParserPool.getEntityResolver(), (String)"EntityResolver is non-null");
        Assert.assertNotNull((Object)this.basicParserPool.getErrorHandler(), (String)"ErrorHandler was null");
    }

    @Test
    public void testInit() throws ComponentInitializationException, SAXException, XMLParserException, IOException {
        Object[] data;
        Boolean thrown = false;
        try {
            this.basicParserPool.newDocument();
        }
        catch (UninitializedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"newDocument before init");
        thrown = false;
        try {
            data = new byte[]{1, 2};
            this.basicParserPool.parse((InputStream)new ByteArrayInputStream((byte[])data));
        }
        catch (UninitializedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"parse before init");
        thrown = false;
        try {
            data = new char[]{'1', '2'};
            this.basicParserPool.parse((Reader)new CharArrayReader((char[])data, 0, data.length));
        }
        catch (UninitializedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"parse before init");
        this.basicParserPool.initialize();
        thrown = false;
        try {
            this.basicParserPool.setBuilderAttributes(new HashMap());
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setBuilderAttributes after init");
        thrown = false;
        try {
            this.basicParserPool.setBuilderFeatures(new HashMap());
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setBuilderFeatures after init");
        thrown = false;
        try {
            this.basicParserPool.setCoalescing(true);
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setCoalescing after init");
        thrown = false;
        try {
            this.basicParserPool.setDTDValidating(true);
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setDTDValidating after init");
        thrown = false;
        try {
            this.basicParserPool.setExpandEntityReferences(true);
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setExpandEntityReferences after init");
        thrown = false;
        try {
            this.basicParserPool.setIgnoreComments(true);
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setIgnoreComments after init");
        thrown = false;
        try {
            this.basicParserPool.setIgnoreElementContentWhitespace(true);
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setIgnoreElementContentWhitespace after init");
        thrown = false;
        try {
            this.basicParserPool.setNamespaceAware(true);
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setNamespaceAware after init");
        ClassPathResource r = new ClassPathResource(SCHEMA_FILE);
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addSchema(r.getInputStream());
        Schema schema = schemaBuilder.buildSchema();
        thrown = false;
        try {
            this.basicParserPool.setSchema(schema);
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setSchema after init");
        thrown = false;
        try {
            this.basicParserPool.setXincludeAware(true);
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setXincludeAware after init");
        thrown = false;
        try {
            this.basicParserPool.setEntityResolver((EntityResolver)new MockEntityResolver());
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setEntityResolver after init");
        thrown = false;
        try {
            this.basicParserPool.setErrorHandler((ErrorHandler)new MockErrorHandler());
        }
        catch (UnmodifiableComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setErrorHandler after init");
        thrown = false;
        try {
            this.basicParserPool.initialize();
        }
        catch (ComponentInitializationException e) {
            thrown = true;
        }
        Assert.assertFalse((boolean)thrown, (String)"double initialize after init");
        this.basicParserPool.destroy();
    }

    @Test
    public void testDestroy() throws ComponentInitializationException, SAXException, IOException {
        BasicParserPool pool = new BasicParserPool();
        pool.destroy();
        Boolean thrown = false;
        try {
            pool.initialize();
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        catch (ComponentInitializationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"initialize after destroy");
        try {
            pool.setBuilderAttributes(new HashMap());
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setBuilderAttributes after destroy");
        thrown = false;
        try {
            pool.setBuilderFeatures(new HashMap());
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setBuilderFeatures after destroy");
        thrown = false;
        try {
            pool.setCoalescing(true);
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setCoalescing after destroy");
        thrown = false;
        try {
            pool.setDTDValidating(true);
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setDTDValidating after destroy");
        thrown = false;
        try {
            pool.setExpandEntityReferences(true);
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setExpandEntityReferences after destroy");
        thrown = false;
        try {
            pool.setIgnoreComments(true);
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setIgnoreComments after destroy");
        thrown = false;
        try {
            pool.setIgnoreElementContentWhitespace(true);
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setIgnoreElementContentWhitespace after destroy");
        thrown = false;
        try {
            pool.setNamespaceAware(true);
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setNamespaceAware after destroy");
        ClassPathResource r = new ClassPathResource(SCHEMA_FILE);
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addSchema(r.getInputStream());
        Schema schema = schemaBuilder.buildSchema();
        thrown = false;
        try {
            pool.setSchema(schema);
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setSchema after destroy");
        thrown = false;
        try {
            pool.setXincludeAware(true);
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setXincludeAware after destroy");
        thrown = false;
        try {
            pool.setEntityResolver((EntityResolver)new MockEntityResolver());
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setEntityResolver after destroy");
        thrown = false;
        try {
            pool.setErrorHandler((ErrorHandler)new MockErrorHandler());
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"setErrorHandler after destroy");
        thrown = false;
        try {
            pool.initialize();
        }
        catch (DestroyedComponentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"double initialize after destroy");
    }

    private void checkParsedDocument(Document document) {
        List list = ElementSupport.getChildElements((Node)document);
        Assert.assertEquals((int)list.size(), (int)1, (String)"Only one element at root!");
        Element root = (Element)list.get(0);
        Assert.assertEquals((String)root.getLocalName(), (String)"Parent", (String)"Check root name");
        Assert.assertEquals((String)root.getNamespaceURI(), (String)"https://www.example.org/Example", (String)"Check root namespace");
        list = ElementSupport.getChildElements((Node)root);
        Assert.assertEquals((int)list.size(), (int)2, (String)"Two children");
        Assert.assertEquals((String)((Element)list.get(0)).getLocalName(), (String)"Child1", (String)"Check first child name");
        Assert.assertEquals((String)((Element)list.get(0)).getNamespaceURI(), (String)"https://www.example.org/Example", (String)"Check first child namespace");
        Assert.assertEquals((String)((Element)list.get(1)).getLocalName(), (String)"Child2", (String)"Check second child name");
        Assert.assertEquals((String)((Element)list.get(1)).getNamespaceURI(), (String)"https://www.example.org/Example", (String)"Check second child namespace");
    }

    @Test
    public void testParse() throws IOException, ComponentInitializationException, XMLParserException, FileNotFoundException {
        this.basicParserPool.initialize();
        ClassPathResource r = new ClassPathResource(XML_FILE);
        this.checkParsedDocument(this.basicParserPool.parse(r.getInputStream()));
        this.checkParsedDocument(this.basicParserPool.parse((Reader)new FileReader("src/test/resources//net/shibboleth/utilities/java/support/xml/basicParserPoolTest.xml")));
    }

    @Test(expectedExceptions={XMLParserException.class})
    public void testDTD() throws IOException, ComponentInitializationException, XMLParserException, FileNotFoundException {
        this.basicParserPool.initialize();
        ClassPathResource r = new ClassPathResource(DTD_FILE);
        this.basicParserPool.parse(r.getInputStream());
    }

    @Test
    public void testNewDocument() throws ComponentInitializationException, XMLParserException {
        this.basicParserPool.initialize();
        Assert.assertNotNull((Object)this.basicParserPool.newDocument(), (String)"Create new document");
    }

    private void testDeadBuilder(DocumentBuilder builder) {
        boolean thrown = false;
        try {
            builder.newDocument();
        }
        catch (IllegalStateException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Dead builder should not create a new document");
    }

    @Test
    public void testGetReturn() throws ComponentInitializationException, XMLParserException {
        int i;
        this.basicParserPool.initialize();
        DocumentBuilder builder = this.basicParserPool.getBuilder();
        this.basicParserPool.returnBuilder(builder);
        this.testDeadBuilder(builder);
        this.basicParserPool.returnBuilder(builder);
        DocumentBuilder[] builders = new DocumentBuilder[10];
        builder = this.basicParserPool.getBuilder();
        for (i = 0; i < builders.length; ++i) {
            builders[i] = this.basicParserPool.getBuilder();
        }
        DocumentBuilder builder2 = this.basicParserPool.getBuilder();
        System.gc();
        System.gc();
        builder.newDocument();
        for (i = 0; i < builders.length; ++i) {
            builders[i].newDocument();
        }
        builder2.newDocument();
        this.basicParserPool.returnBuilder(builder);
        for (i = 0; i < builders.length; ++i) {
            this.basicParserPool.returnBuilder(builders[i]);
        }
        this.basicParserPool.returnBuilder(builder2);
        System.gc();
        System.gc();
        this.testDeadBuilder(builder);
        for (i = 0; i < builders.length; ++i) {
            this.testDeadBuilder(builders[i]);
        }
        this.testDeadBuilder(builder2);
        builder = null;
        for (i = 0; i < builders.length; ++i) {
            builders[i] = null;
        }
        builder2 = null;
        System.gc();
        System.gc();
        for (i = 0; i < builders.length; ++i) {
            builders[i] = this.basicParserPool.getBuilder();
            builders[i].newDocument();
        }
        for (i = 0; i < builders.length; ++i) {
            this.basicParserPool.returnBuilder(builders[i]);
        }
    }

    @Test
    public void testFinalize() throws XMLParserException, ComponentInitializationException {
        BasicParserPool pool = new BasicParserPool();
        pool.initialize();
        Assert.assertEquals((int)0, (int)pool.getPoolSize());
        DocumentBuilder builder = pool.getBuilder();
        pool.returnBuilder(builder);
        Assert.assertEquals((int)1, (int)pool.getPoolSize());
        try {
            ((BasicParserPool.DocumentBuilderProxy)builder).finalize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Assert.assertEquals((int)1, (int)pool.getPoolSize());
        DocumentBuilder builder1 = ((BasicParserPool.DocumentBuilderProxy)pool.getBuilder()).getProxiedBuilder();
        Assert.assertNotNull((Object)builder1);
        DocumentBuilder builder2 = ((BasicParserPool.DocumentBuilderProxy)pool.getBuilder()).getProxiedBuilder();
        Assert.assertNotNull((Object)builder2);
        Assert.assertFalse((boolean)builder1.equals(builder2));
    }

    @Test
    public void testExplicitMultipleReturn() throws XMLParserException, ComponentInitializationException {
        this.basicParserPool.initialize();
        Assert.assertEquals((int)0, (int)this.basicParserPool.getPoolSize());
        DocumentBuilder builder = this.basicParserPool.getBuilder();
        this.basicParserPool.returnBuilder(builder);
        Assert.assertEquals((int)1, (int)this.basicParserPool.getPoolSize());
        this.basicParserPool.returnBuilder(builder);
        Assert.assertEquals((int)1, (int)this.basicParserPool.getPoolSize());
        DocumentBuilder builder1 = ((BasicParserPool.DocumentBuilderProxy)this.basicParserPool.getBuilder()).getProxiedBuilder();
        Assert.assertNotNull((Object)builder1);
        DocumentBuilder builder2 = ((BasicParserPool.DocumentBuilderProxy)this.basicParserPool.getBuilder()).getProxiedBuilder();
        Assert.assertNotNull((Object)builder2);
        Assert.assertFalse((boolean)builder1.equals(builder2));
    }

    @Test
    public void testParserUseAfterReturn() throws XMLParserException, URISyntaxException, ComponentInitializationException {
        this.basicParserPool.initialize();
        String testPath = "/net/shibboleth/utilities/java/support/xml/foo.xml";
        InputStream is = BasicParserPoolTest.class.getResourceAsStream(testPath);
        File file = new File(this.getClass().getResource(testPath).toURI());
        DocumentBuilder builder = this.basicParserPool.getBuilder();
        try {
            builder.parse(file);
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"Parser proxy was in a valid state");
        }
        catch (SAXException e) {
            Assert.fail((String)"Parser proxy was in a valid state");
        }
        catch (IOException e) {
            Assert.fail((String)"Parser proxy was in a valid state");
        }
        this.basicParserPool.returnBuilder(builder);
        try {
            builder.parse(file);
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        catch (IllegalStateException e) {
        }
        catch (SAXException e) {
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        catch (IOException e) {
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        try {
            builder.parse(is);
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        catch (IllegalStateException e) {
        }
        catch (SAXException e) {
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        catch (IOException e) {
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        try {
            builder.parse(new InputSource(is));
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        catch (IllegalStateException e) {
        }
        catch (SAXException e) {
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        catch (IOException e) {
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        try {
            builder.parse(file.toURI().toString());
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        catch (IllegalStateException e) {
        }
        catch (SAXException e) {
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
        catch (IOException e) {
            Assert.fail((String)"Parser proxy was in an illegal state");
        }
    }

    @Test
    public void testMaxPoolSize() throws XMLParserException, ComponentInitializationException {
        this.basicParserPool.initialize();
        Assert.assertEquals((int)0, (int)this.basicParserPool.getPoolSize());
        ArrayList<DocumentBuilder> list = new ArrayList<DocumentBuilder>();
        for (int i = 0; i < 3 * this.maxPoolSize; ++i) {
            list.add(this.basicParserPool.getBuilder());
        }
        Assert.assertEquals((int)0, (int)this.basicParserPool.getPoolSize());
        for (DocumentBuilder b : list) {
            this.basicParserPool.returnBuilder(b);
        }
        Assert.assertEquals((int)this.maxPoolSize, (int)this.basicParserPool.getPoolSize());
    }

    public static class MockErrorHandler
    implements ErrorHandler {
        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }
    }

    public static class MockEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return null;
        }
    }
}

