/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.List;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.logic.TransformAndCheckFunction;
import net.shibboleth.utilities.java.support.logic.TrimOrNullStringFunction;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TransformAndCheckFunctionTest {
    private final List<String> excludes = Arrays.asList("one", "2", "iii");

    @Test
    public void testConstructorFails() {
        TransformAndCheckFunction f = null;
        boolean thrown = false;
        try {
            f = new TransformAndCheckFunction(null, (Predicate)new MyPredicate(), true);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Null function should throw");
        thrown = false;
        try {
            f = new TransformAndCheckFunction((Function)TrimOrNullStringFunction.INSTANCE, null, true);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Null predicate should throw");
        Assert.assertNull((Object)f, (String)"silence compiler warning");
    }

    @Test
    public void testApply() {
        TransformAndCheckFunction f = new TransformAndCheckFunction((Function)TrimOrNullStringFunction.INSTANCE, (Predicate)new MyPredicate(), false);
        Assert.assertFalse((boolean)((Optional)f.apply((Object)" two")).isPresent(), (String)"Should not be present since the predicate failed");
        Assert.assertEquals((String)((String)((Optional)f.apply((Object)" iii ")).get()), (String)"iii", (String)"present and trimmed");
        f = new TransformAndCheckFunction((Function)TrimOrNullStringFunction.INSTANCE, (Predicate)new MyPredicate(), true);
        Assert.assertEquals((String)((String)((Optional)f.apply((Object)" iii ")).get()), (String)"iii", (String)"present and trimmed");
        boolean thrown = false;
        try {
            f.apply((Object)" two");
        }
        catch (IllegalArgumentException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"mismatch should throw");
    }

    public class MyPredicate
    implements Predicate<String> {
        public boolean apply(String input) {
            for (String s : TransformAndCheckFunctionTest.this.excludes) {
                if (!s.equals(input)) continue;
                return true;
            }
            return false;
        }
    }
}

