/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class QNameSupportTest {
    private static final String NAME_1 = "name1";
    private static final String NAME_2 = "name2";
    private static final String NAME_3 = "name3";
    private static final String NAMESPACE_1 = "http://example.org/NameSpace1";
    private static final String NAMESPACE_2 = "http://example.org/NameSpace2";
    private static final String DEFAULT_NAMESPACE = "http://example.org/DefaultSpace";
    private static final String PREFIX_1 = "myns1";
    private static final String PREFIX_2 = "myns2";
    private ParserPool parserPool;
    private Element parent;
    private Element child;

    @BeforeTest
    public void setup() throws ComponentInitializationException, SAXException, IOException, XMLParserException {
        BasicParserPool pool = new BasicParserPool();
        pool.initialize();
        this.parserPool = pool;
        DocumentBuilder builder = this.parserPool.getBuilder();
        ClassPathResource resource = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/qNameSupportTest.xml");
        Document testFile = builder.parse(resource.getInputStream());
        this.parent = (Element)testFile.getFirstChild();
        this.child = ElementSupport.getFirstChildElement((Node)this.parent);
        if (null != builder) {
            this.parserPool.returnBuilder(builder);
        }
    }

    @Test
    public void testConstructQName() {
        QName qn = QNameSupport.constructQName((String)NAMESPACE_1, (String)NAME_1, (String)PREFIX_1);
        Assert.assertEquals((String)qn.getLocalPart(), (String)NAME_1, (String)"Simple qname construction");
        Assert.assertEquals((String)qn.getNamespaceURI(), (String)NAMESPACE_1, (String)"Simple qname construction");
        Assert.assertEquals((String)qn.getPrefix(), (String)PREFIX_1, (String)"Simple qname construction");
        qn = QNameSupport.constructQName((String)"", (String)NAME_2, (String)PREFIX_2);
        Assert.assertEquals((String)qn.getLocalPart(), (String)NAME_2, (String)"Simple qname construction");
        Assert.assertEquals((String)qn.getNamespaceURI(), (String)"", (String)"Simple qname construction");
        Assert.assertEquals((String)qn.getPrefix(), (String)PREFIX_2, (String)"Simple qname construction");
        qn = QNameSupport.constructQName((String)NAMESPACE_2, (String)NAME_2, (String)"");
        Assert.assertEquals((String)qn.getLocalPart(), (String)NAME_2, (String)"Simple qname construction");
        Assert.assertEquals((String)qn.getNamespaceURI(), (String)NAMESPACE_2, (String)"Simple qname construction");
        Assert.assertEquals((String)qn.getPrefix(), (String)"", (String)"Simple qname construction");
        boolean thrown = false;
        try {
            QNameSupport.constructQName((String)NAMESPACE_2, (String)"", (String)PREFIX_1);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Fail to construct a qname with a null namespace");
        qn = QNameSupport.constructQName((Element)this.child, (String)NAME_1);
        Assert.assertEquals((String)qn.getLocalPart(), (String)NAME_1, (String)"Element qname construction");
        Assert.assertEquals((String)qn.getNamespaceURI(), (String)DEFAULT_NAMESPACE, (String)"Element qname construction");
        Assert.assertEquals((String)qn.getPrefix(), (String)"", (String)"Element qname construction");
        qn = QNameSupport.constructQName((Element)this.child, (String)"myns1:name2");
        Assert.assertEquals((String)qn.getLocalPart(), (String)NAME_2, (String)"Element qname construction");
        Assert.assertEquals((String)qn.getNamespaceURI(), (String)NAMESPACE_1, (String)"Element qname construction");
        Assert.assertEquals((String)qn.getPrefix(), (String)PREFIX_1, (String)"Element qname construction");
        qn = QNameSupport.constructQName((Element)this.child, (String)"myns2:name3");
        Assert.assertEquals((String)qn.getLocalPart(), (String)NAME_3, (String)"Element qname construction");
        Assert.assertEquals((String)qn.getNamespaceURI(), (String)"", (String)"Element qname construction");
        Assert.assertEquals((String)qn.getPrefix(), (String)PREFIX_2, (String)"Element qname construction");
        thrown = false;
        try {
            QNameSupport.constructQName((Element)this.child, null);
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Element qname construction");
        thrown = false;
        try {
            QNameSupport.constructQName(null, (String)"myns2:name3");
        }
        catch (ConstraintViolationException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Element qname construction");
    }

    @Test
    public void testGetNodeQName() {
        QName qn = QNameSupport.getNodeQName((Node)this.parent);
        Assert.assertEquals((String)qn.getLocalPart(), (String)"Parent", (String)"Get Node QName");
        Assert.assertEquals((String)qn.getNamespaceURI(), (String)DEFAULT_NAMESPACE, (String)"Get Node QName");
        Assert.assertEquals((String)qn.getPrefix(), (String)"", (String)"Get Node QName");
        qn = QNameSupport.getNodeQName((Node)this.child);
        Assert.assertEquals((String)qn.getLocalPart(), (String)"Child", (String)"Get Node QName");
        Assert.assertEquals((String)qn.getNamespaceURI(), (String)NAMESPACE_1, (String)"Get Node QName");
        Assert.assertEquals((String)qn.getPrefix(), (String)PREFIX_1, (String)"Get Node QName");
    }

    @Test
    public void testQNameToContentString() {
        Assert.assertEquals((String)QNameSupport.qnameToContentString((QName)new QName(NAMESPACE_1, NAME_1, PREFIX_1)), (String)"myns1:name1");
        Assert.assertEquals((String)QNameSupport.qnameToContentString((QName)new QName(NAME_2)), (String)NAME_2);
    }
}

