/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.resource.TestResourceConverter;
import net.shibboleth.utilities.java.support.xml.SchemaBuilder;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class SchemaBuilderTest {
    private static final String TEST_DIR = "/net/shibboleth/utilities/java/support/xml/schemaBuilderTestDir/";
    private static final String FILE_ROOT = "src/test/resources/";
    private static final String FIRST_SCHEMA_FILE = "schemaBuilderTest-schemaFirstLoaded.xsd";
    private static final String SECOND_SCHEMA_FILE = "schemaBuilderTest-schemaSecondLoaded.xsd";
    private org.springframework.core.io.Resource works;
    private org.springframework.core.io.Resource fails;

    private StreamSource workingSource() throws IOException {
        return new StreamSource(this.works.getInputStream());
    }

    private StreamSource failingSource() throws IOException {
        return new StreamSource(this.fails.getInputStream());
    }

    @BeforeTest
    public void setup() {
        this.works = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/schemaBuilderTestDir/schemaBuilderTest-works.xml");
        this.fails = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/schemaBuilderTestDir/schemaBuilderTest-fails.xml");
    }

    @Test
    public void testFiles() throws SAXException, IOException {
        FileInputStream first = new FileInputStream("src/test/resources//net/shibboleth/utilities/java/support/xml/schemaBuilderTestDir/schemaBuilderTest-schemaFirstLoaded.xsd");
        FileInputStream second = new FileInputStream("src/test/resources//net/shibboleth/utilities/java/support/xml/schemaBuilderTestDir/schemaBuilderTest-schemaSecondLoaded.xsd");
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema((InputStream)first);
        builder.addSchema((InputStream)second);
        Schema schema = builder.buildSchema();
        Validator validator = schema.newValidator();
        validator.validate(this.workingSource());
        boolean thrown = false;
        StreamSource fails = this.failingSource();
        try {
            validator.validate(fails);
        }
        catch (Exception e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should fail to validate");
    }

    @Test
    public void testInputStream() throws SAXException, IOException, ComponentInitializationException {
        ClassPathResource first = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/schemaBuilderTestDir/schemaBuilderTest-schemaFirstLoaded.xsd");
        ClassPathResource second = new ClassPathResource("/net/shibboleth/utilities/java/support/xml/schemaBuilderTestDir/schemaBuilderTest-schemaSecondLoaded.xsd");
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(first.getInputStream());
        builder.addSchema(second.getInputStream());
        Schema schema = builder.buildSchema();
        Validator validator = schema.newValidator();
        validator.validate(this.workingSource());
        boolean thrown = false;
        StreamSource fails = this.failingSource();
        try {
            validator.validate(fails);
        }
        catch (Exception e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should fail to validate");
    }

    @Test
    public void testResource() throws SAXException, IOException, ComponentInitializationException {
        Resource first = TestResourceConverter.of((org.springframework.core.io.Resource)new ClassPathResource("/net/shibboleth/utilities/java/support/xml/schemaBuilderTestDir/schemaBuilderTest-schemaFirstLoaded.xsd"));
        Resource second = TestResourceConverter.of((org.springframework.core.io.Resource)new ClassPathResource("/net/shibboleth/utilities/java/support/xml/schemaBuilderTestDir/schemaBuilderTest-schemaSecondLoaded.xsd"));
        SchemaBuilder builder = new SchemaBuilder();
        builder.addSchema(first);
        builder.addSchema(second);
        Schema schema = builder.buildSchema();
        Validator validator = schema.newValidator();
        validator.validate(this.workingSource());
        boolean thrown = false;
        StreamSource fails = this.failingSource();
        try {
            validator.validate(fails);
        }
        catch (Exception e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown, (String)"Should fail to validate");
    }
}

