package net.silkmc.silk.core.mixin.entity;

import EntityEvents.EntityCheckInvulnerabilityEvent;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.silkmc.silk.core.event.EntityEvents;
import net.silkmc.silk.core.event.EventScopeProperty;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1297.class)
public class MixinEntity {

    @Inject(
        method = "isInvulnerableTo",
        at = @At("RETURN"),
        cancellable = true
    )
    private void onIsInvulnerableTo(class_1282 damageSource,
                                    CallbackInfoReturnable<Boolean> cir) {
        final var returnValue = cir.getReturnValue();

        final var event = new EntityEvents.EntityCheckInvulnerabilityEvent(
            (class_1297) (Object) this,
            damageSource,
            new EventScopeProperty<>(returnValue)
        );

        EntityEvents.INSTANCE.getCheckInvulnerability().invoke(event);

        if (event.isInvulnerable().get() != returnValue) {
            cir.setReturnValue(event.isInvulnerable().get());
        }
    }
}
