package net.silkmc.silk.core.mixin.server;

import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import net.silkmc.silk.core.event.PlayerEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3324.class)
public class MixinPlayerList {

    @Inject(
        method = "placeNewPlayer",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/server/network/ServerGamePacketListenerImpl;<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V",
            shift = At.Shift.BEFORE
        )
    )
    private void onPreLogin(class_2535 connection, class_3222 player, class_8792 commonListenerCookie, CallbackInfo ci) {
        PlayerEvents.INSTANCE.getPreLogin().invoke(new PlayerEvents.PlayerEvent<>(player));
    }

    @Inject(
        method = "placeNewPlayer",
        at = @At("TAIL")
    )
    private void onPostLogin(class_2535 connection, class_3222 player, class_8792 commonListenerCookie, CallbackInfo ci) {
        PlayerEvents.INSTANCE.getPostLogin().invoke(new PlayerEvents.PlayerEvent<>(player));
    }
}
