/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.springboot.config.ui;

import org.mitre.openid.connect.config.JsonMessageSource;
import org.mitre.openid.connect.web.ServerConfigInterceptor;
import org.mitre.openid.connect.web.UserInfoInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebMvc
public class WebMvcConfig
extends WebMvcConfigurerAdapter {
    @Bean
    @ConditionalOnMissingBean(value={UserInfoInterceptor.class})
    public UserInfoInterceptor getUserInfoInterceptor() {
        return new UserInfoInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={ServerConfigInterceptor.class})
    public ServerConfigInterceptor getServerConfigInterceptor() {
        return new ServerConfigInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean(value={JsonMessageSource.class})
    @ConfigurationProperties(prefix="openid.connect.jsonMessageSource")
    public JsonMessageSource messageSource(@Value(value="classpath:/static/resources/js/locale/") Resource baseDirectory, @Value(value="true") Boolean useCodeAsDefaultMessage) {
        JsonMessageSource jsonMessageSource = new JsonMessageSource();
        jsonMessageSource.setBaseDirectory(baseDirectory);
        jsonMessageSource.setUseCodeAsDefaultMessage(useCodeAsDefaultMessage.booleanValue());
        return jsonMessageSource;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.getUserInfoInterceptor());
        registry.addInterceptor((HandlerInterceptor)this.getServerConfigInterceptor());
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/login").setViewName("login");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/resources/**"}).addResourceLocations(new String[]{"classpath:/static/resources/"});
    }
}

