/*
 * Decompiled with CFR 0.152.
 */
package an.awesome.pipelinr.repack.com.google.common.cache;

import an.awesome.pipelinr.repack.com.google.common.annotations.GwtCompatible;
import an.awesome.pipelinr.repack.com.google.common.cache.CacheStats;
import an.awesome.pipelinr.repack.com.google.common.cache.ElementTypesAreNonnullByDefault;
import an.awesome.pipelinr.repack.com.google.common.collect.ImmutableMap;
import an.awesome.pipelinr.repack.com.google.errorprone.annotations.CheckReturnValue;
import an.awesome.pipelinr.repack.com.google.errorprone.annotations.CompatibleWith;
import an.awesome.pipelinr.repack.com.google.errorprone.annotations.DoNotMock;
import an.awesome.pipelinr.repack.javax.annotation.CheckForNull;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

@DoNotMock(value="Use CacheBuilder.newBuilder().build()")
@ElementTypesAreNonnullByDefault
@GwtCompatible
public interface Cache<K, V> {
    @CheckForNull
    public V getIfPresent(@CompatibleWith(value="K") Object var1);

    public V get(K var1, Callable<? extends V> var2) throws ExecutionException;

    public ImmutableMap<K, V> getAllPresent(Iterable<? extends Object> var1);

    public void put(K var1, V var2);

    public void putAll(Map<? extends K, ? extends V> var1);

    public void invalidate(@CompatibleWith(value="K") Object var1);

    public void invalidateAll(Iterable<? extends Object> var1);

    public void invalidateAll();

    @CheckReturnValue
    public long size();

    @CheckReturnValue
    public CacheStats stats();

    @CheckReturnValue
    public ConcurrentMap<K, V> asMap();

    public void cleanUp();
}

