/*
 * Decompiled with CFR 0.152.
 */
package net.smacke.jaydio;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import net.smacke.jaydio.buffer.AlignedDirectByteBuffer;
import org.apache.log4j.Logger;

public class DirectIoLib {
    private static final Logger logger = Logger.getLogger(DirectIoLib.class);
    private static boolean binit = false;
    private int fsBlockSize;
    private long fsBlockNotMask;

    protected DirectIoLib(int fsBlockSize) {
        this.fsBlockSize = fsBlockSize;
        this.fsBlockNotMask = (long)fsBlockSize - 1L ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static DirectIoLib getLibForPath(String workingDir) {
        int fsBlockSize = DirectIoLib.initilizeSoftBlockSize(workingDir);
        if (fsBlockSize == -1) {
            logger.warn((Object)("O_DIRECT support non available on your version of Linux (" + System.getProperty("os.version") + "), " + "please upgrade your kernel in order to use jaydio."));
            return null;
        }
        return new DirectIoLib(fsBlockSize);
    }

    private static int initilizeSoftBlockSize(String fileOrDir) {
        int fsBlockSize = -1;
        if (binit) {
            int _PC_REC_XFER_ALIGN = 17;
            fsBlockSize = DirectIoLib.pathconf(fileOrDir, 17);
            int pageSize = DirectIoLib.getpagesize();
            fsBlockSize = DirectIoLib.lcm(fsBlockSize, pageSize);
            if ((fsBlockSize = DirectIoLib.lcm(fsBlockSize, 512L)) <= 0 || (fsBlockSize & fsBlockSize - 1) != 0) {
                logger.warn((Object)("file system block size should be a power of two, was found to be " + fsBlockSize));
                logger.warn((Object)"Disabling O_DIRECT support");
                return -1;
            }
        }
        return fsBlockSize;
    }

    public int pread(int fd, AlignedDirectByteBuffer buf, long offset) throws IOException {
        buf.clear();
        int n = DirectIoLib.pread(fd, buf.pointer(), new NativeLong((long)buf.capacity()), new NativeLong(offset)).intValue();
        if (n == 0) {
            throw new EOFException("Tried to read past EOF at offset " + offset + " into ByteBuffer " + buf);
        }
        if (n < 0) {
            throw new IOException("error reading file at offset " + offset + ": " + DirectIoLib.getLastError());
        }
        return n;
    }

    public int pwrite(int fd, AlignedDirectByteBuffer buf, long offset) throws IOException {
        int start = buf.position();
        assert (start == this.blockStart(start));
        int toWrite = this.blockEnd(buf.limit()) - start;
        int n = DirectIoLib.pwrite(fd, buf.pointer().share((long)start), new NativeLong((long)toWrite), new NativeLong(offset)).intValue();
        if (n < 0) {
            throw new IOException("error writing file at offset " + offset + ": " + DirectIoLib.getLastError());
        }
        return n;
    }

    public int oDirectOpen(String pathname, boolean readOnly) throws IOException {
        int flags = 16384;
        flags = readOnly ? (flags |= 0) : (flags |= 0x42);
        int fd = DirectIoLib.open(pathname, flags, 420);
        if (fd < 0) {
            throw new IOException("Error opening " + pathname + ", got " + DirectIoLib.getLastError());
        }
        return fd;
    }

    public static String getLastError() {
        return DirectIoLib.strerror(Native.getLastError());
    }

    public int blockSize() {
        return this.fsBlockSize;
    }

    public int defaultBufferSize() {
        return this.fsBlockSize;
    }

    public long blockStart(long value) {
        return value & this.fsBlockNotMask;
    }

    public int blockStart(int value) {
        return (int)((long)value & this.fsBlockNotMask);
    }

    public long blockEnd(long value) {
        return value + (long)this.fsBlockSize - 1L & this.fsBlockNotMask;
    }

    public int blockEnd(int value) {
        return (int)((long)(value + this.fsBlockSize - 1) & this.fsBlockNotMask);
    }

    public static long blockEnd(int blockSize, long position) {
        long ceil = (position + (long)blockSize - 1L) / (long)blockSize;
        return ceil * (long)blockSize;
    }

    public static int lcm(long x, long y) {
        long g = x;
        long yc = y;
        while (yc != 0L) {
            long t = g;
            g = yc;
            yc = t % yc;
        }
        return (int)(x * y / g);
    }

    public static native int posix_memalign(PointerByReference var0, NativeLong var1, NativeLong var2);

    public static native void free(Pointer var0);

    public native int close(int var1);

    public static native int ftruncate(int var0, long var1);

    private static native NativeLong pwrite(int var0, Pointer var1, NativeLong var2, NativeLong var3);

    private static native NativeLong pread(int var0, Pointer var1, NativeLong var2, NativeLong var3);

    private static native int open(String var0, int var1);

    private static native int open(String var0, int var1, int var2);

    private static native int getpagesize();

    private static native int pathconf(String var0, int var1);

    private static native String strerror(int var0);

    static {
        try {
            if (!Platform.isLinux()) {
                logger.warn((Object)"Not running Linux, jaydio support disabled");
            } else {
                boolean linuxVersion = false;
                boolean majorRev = true;
                int minorRev = 2;
                ArrayList<Integer> versionNumbers = new ArrayList<Integer>();
                for (String v : System.getProperty("os.version").split("\\.|-")) {
                    if (!v.matches("\\d")) continue;
                    versionNumbers.add(Integer.parseInt(v));
                }
                if ((Integer)versionNumbers.get(0) > 2) {
                    binit = true;
                } else if ((Integer)versionNumbers.get(0) == 2) {
                    if ((Integer)versionNumbers.get(1) > 4) {
                        binit = true;
                    } else if ((Integer)versionNumbers.get(1) == 4 && (Integer)versionNumbers.get(2) >= 10) {
                        binit = true;
                    }
                }
                if (binit) {
                    Native.register((String)Platform.C_LIBRARY_NAME);
                } else {
                    logger.warn((Object)String.format("O_DIRECT not supported on your version of Linux: %d.%d.%d", 0, 1, 2));
                }
            }
        }
        catch (Throwable e) {
            logger.warn((Object)("Unable to register libc at class load time: " + e.getMessage()), e);
        }
    }
}

