/*
 * Decompiled with CFR 0.152.
 */
package net.smacke.jaydio;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.smacke.jaydio.align.DirectIoByteChannelAligner;

public class DirectRandomAccessFile
implements DataInput,
DataOutput,
Closeable {
    private static final String UTF8_BOM = Character.toString('\u00ef') + Character.toString('\u00bb') + Character.toString('\u00bf');
    private DirectIoByteChannelAligner channel;

    public DirectRandomAccessFile(String name, String mode) throws IOException {
        this(new File(name), mode);
    }

    public DirectRandomAccessFile(File file, String mode) throws IOException {
        this(file, mode, -1);
    }

    public DirectRandomAccessFile(File file, String mode, int bufferSize) throws IOException {
        boolean readOnly = false;
        if (mode.equals("r")) {
            readOnly = true;
        } else if (!mode.equals("rw")) {
            throw new IllegalArgumentException("only r and rw modes supported");
        }
        if (readOnly && !file.isFile()) {
            throw new FileNotFoundException("couldn't find file " + file);
        }
        this.channel = bufferSize != -1 ? DirectIoByteChannelAligner.open(file, bufferSize, readOnly) : DirectIoByteChannelAligner.open(file, readOnly);
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public void write(int v) throws IOException {
        this.channel.write(v);
    }

    @Override
    public void write(byte[] src) throws IOException {
        this.write(src, 0, src.length);
    }

    @Override
    public void write(byte[] src, int offset, int length) throws IOException {
        this.channel.writeBytes(src, offset, length);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.write(b);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes());
    }

    @Override
    public void writeChar(int c) throws IOException {
        this.write(c >>> 8 & 0xFF);
        this.write(c >>> 0 & 0xFF);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int numChars = s.length();
        int numBytes = 2 * numChars;
        byte[] sBytes = new byte[numBytes];
        char[] sChars = new char[numChars];
        s.getChars(0, numChars, sChars, 0);
        int bPos = 0;
        for (int i = 0; i < numChars; ++i) {
            sBytes[bPos++] = (byte)(sChars[i] >>> 8);
            sBytes[bPos++] = (byte)(sChars[i] >>> 0);
        }
        this.write(sBytes, 0, numBytes);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)v & 0xFF);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        throw new UnsupportedOperationException("not implemented yet!");
    }

    public int read() throws IOException {
        return this.channel.read();
    }

    private int readDetectEOF() throws IOException {
        int v = this.read();
        if (v == -1) {
            throw new EOFException();
        }
        return v;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException();
        }
        return b != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int b = this.read();
        if (b == -1) {
            throw new EOFException();
        }
        return (byte)b;
    }

    @Override
    public char readChar() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        if (ch1 == -1 || ch2 == -1) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void read(byte[] dst, int offset, int length) throws IOException {
        this.channel.readBytes(dst, offset, length);
    }

    public void read(byte[] dst) throws IOException {
        this.channel.readBytes(dst, 0, dst.length);
    }

    @Override
    public void readFully(byte[] src) throws IOException {
        this.readFully(src, 0, src.length);
    }

    @Override
    public void readFully(byte[] src, int offset, int length) throws IOException {
        this.read(src, offset, length);
    }

    @Override
    public int readInt() throws IOException {
        int b1 = this.readDetectEOF();
        int b2 = this.readDetectEOF();
        int b3 = this.readDetectEOF();
        int b4 = this.readDetectEOF();
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    private static String sanitizeUtf8Bom(String s) {
        if (s.startsWith(UTF8_BOM)) {
            s = s.substring(UTF8_BOM.length());
        }
        return s;
    }

    @Override
    public String readLine() throws IOException {
        int c;
        StringBuilder instr = new StringBuilder();
        while ((c = this.read()) != -1 && c != 10) {
            if (c == 13) {
                long pos = this.getFilePointer();
                if (this.read() == 10) break;
                this.seek(pos);
                break;
            }
            instr.append((char)c);
        }
        if (c == -1 && instr.length() == 0) {
            return null;
        }
        String ret = instr.toString();
        return DirectRandomAccessFile.sanitizeUtf8Bom(ret);
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public short readShort() throws IOException {
        int b1 = this.readDetectEOF();
        int b2 = this.readDetectEOF();
        return (short)((b1 << 8) + b2);
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException("not implemented yet!");
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readDetectEOF();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int b1 = this.readDetectEOF();
        int b2 = this.readDetectEOF();
        return (b1 << 8) + b2;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        long pos = this.getFilePointer();
        long newpos = Math.min(pos + (long)n, this.length());
        this.seek(newpos);
        return (int)(newpos - pos);
    }

    public void seek(long pos) throws IOException {
        this.channel.position(pos);
    }

    public long getFilePointer() {
        return this.channel.position();
    }

    public long length() {
        return this.channel.size();
    }
}

