/*
 * Decompiled with CFR 0.152.
 */
package net.smacke.jaydio.align;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import net.smacke.jaydio.DirectIoLib;
import net.smacke.jaydio.buffer.JaydioByteBuffer;
import net.smacke.jaydio.channel.BufferedChannel;

public abstract class ByteChannelAligner<T extends JaydioByteBuffer>
implements SeekableByteChannel {
    T buffer;
    BufferedChannel<T> channel;
    private DirectIoLib lib;
    private boolean isOpen;
    private long filePos;
    private long fileLength;
    private boolean[] dirty;
    private boolean globalDirty;

    public ByteChannelAligner(DirectIoLib lib, BufferedChannel<T> channel, T buffer) {
        this.lib = lib;
        this.buffer = buffer;
        this.channel = channel;
        this.isOpen = true;
        this.fileLength = channel.size();
        this.dirty = new boolean[buffer.capacity() / lib.blockSize()];
        Arrays.fill(this.dirty, false);
        this.globalDirty = false;
        this.positionBufferForFlushAndRefill(0L);
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
    }

    private void ensureWritable() throws NonWritableChannelException {
        if (this.channel.isReadOnly()) {
            throw new NonWritableChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.isOpen) {
            try {
                if (!this.channel.isReadOnly()) {
                    this.truncate(this.size());
                }
            }
            finally {
                this.isOpen = false;
                try {
                    this.channel.close();
                }
                finally {
                    this.buffer.close();
                }
            }
        }
    }

    @Override
    public long position() {
        return this.filePos + (long)this.buffer.position();
    }

    @Override
    public ByteChannelAligner<T> position(long pos) throws IOException {
        this.ensureOpen();
        long alignedPos = this.lib.blockStart(pos);
        if (this.filePos != alignedPos) {
            this.flush();
            if (alignedPos < this.size()) {
                this.positionBufferForFlushAndRefill(alignedPos);
                this.flushAndRefill();
            } else {
                this.filePos = alignedPos;
            }
        }
        int delta = (int)(pos - alignedPos);
        this.buffer.position(delta);
        return this;
    }

    private void positionBufferForFlushAndRefill(long position) {
        assert (this.lib.blockStart(position) == position);
        this.buffer.clear();
        this.filePos = position - (long)this.buffer.capacity();
        this.buffer.position(this.buffer.capacity());
    }

    @Override
    public long size() {
        return this.fileLength;
    }

    public int readBytes(byte[] dst, int offset, int length) throws IOException {
        this.ensureOpen();
        if (this.position() > this.size()) {
            throw new EOFException("trying to read at " + this.position() + " , length is " + this.size());
        }
        if (this.position() == this.size()) {
            return -1;
        }
        int total = 0;
        if (this.buffer.remaining() == 0) {
            this.flushAndRefill();
        }
        while (this.buffer.remaining() > 0 && length > this.buffer.remaining()) {
            int toRead = this.buffer.remaining();
            total += toRead;
            this.buffer.get(dst, offset, toRead);
            offset += toRead;
            if ((length -= toRead) <= 0) continue;
            this.flushAndRefill();
        }
        if (this.buffer.remaining() == 0) {
            return total;
        }
        assert (length <= this.buffer.remaining());
        this.buffer.get(dst, offset, length);
        return total += length;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.ensureOpen();
        int ret = this.readBytes(dst.array(), dst.position(), dst.remaining());
        dst.position(dst.position() + ret);
        return ret;
    }

    public int writeBytes(byte[] src, int offset, int length) throws IOException {
        this.ensureOpen();
        this.ensureWritable();
        int total = 0;
        boolean bufferHasMoved = false;
        if (this.buffer.remaining() == 0) {
            bufferHasMoved = true;
            this.flushAndForwardBufferWithoutRefill();
        }
        while (length > this.buffer.remaining()) {
            int toWrite = this.buffer.remaining();
            total += toWrite;
            this.setDirtyBlocksInRange(this.buffer.position(), this.buffer.capacity());
            this.buffer.put(src, offset, toWrite);
            offset += toWrite;
            length -= toWrite;
            bufferHasMoved = true;
            this.flushAndForwardBufferWithoutRefill();
        }
        assert (length <= this.buffer.remaining());
        if (bufferHasMoved && length < this.buffer.remaining()) {
            this.positionBufferForFlushAndRefill(this.filePos);
            this.flushAndRefill();
        }
        this.setDirtyBlocksInRange(this.buffer.position(), this.buffer.position() + length);
        this.buffer.put(src, offset, length);
        this.fileLength = Math.max(this.fileLength, this.position());
        return total += length;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.ensureOpen();
        this.ensureWritable();
        int ret = this.writeBytes(src.array(), src.position(), src.remaining());
        src.position(src.position() + ret);
        return ret;
    }

    public void write(int b) throws IOException {
        this.ensureOpen();
        this.ensureWritable();
        if (this.buffer.remaining() == 0) {
            this.flushAndRefill();
        }
        this.dirty[this.buffer.position() / this.lib.blockSize()] = true;
        this.buffer.put((byte)b);
        this.fileLength = Math.max(this.fileLength, this.position());
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.position() > this.size()) {
            throw new EOFException("trying to read at " + this.position() + " , length is " + this.size());
        }
        if (this.position() == this.size()) {
            return -1;
        }
        if (this.buffer.remaining() == 0) {
            this.flushAndRefill();
        }
        return this.buffer.get() & 0xFF;
    }

    private void flushAndForwardBufferWithoutRefill() throws IOException {
        assert (this.buffer.remaining() == 0);
        this.flush();
        this.filePos += (long)this.buffer.capacity();
        this.buffer.clear();
    }

    private void setDirtyBlocksInRange(int start, int stop) {
        int i = start / this.lib.blockSize();
        while (i * this.lib.blockSize() < stop) {
            this.dirty[i] = true;
            ++i;
        }
        this.globalDirty = true;
    }

    private void refill() throws IOException {
        assert (this.buffer.position() == 0);
        if (this.position() < this.size()) {
            assert (this.lib.blockStart(this.filePos) == this.filePos) : "filePos is not a multiple of " + this.lib.blockSize() + ": filePos=" + this.filePos;
            this.channel.read(this.buffer, this.filePos);
            this.buffer.clear();
        }
    }

    private void flushAndRefill() throws IOException {
        assert (this.buffer.remaining() == 0);
        this.flushAndForwardBufferWithoutRefill();
        this.refill();
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public ByteChannelAligner<T> truncate(long size) throws IOException {
        this.ensureOpen();
        this.ensureWritable();
        this.flush();
        this.channel.truncate(size);
        this.fileLength = size;
        return this;
    }

    public void flush() throws IOException {
        this.ensureOpen();
        if (!this.globalDirty) {
            return;
        }
        this.ensureWritable();
        int oldPos = this.buffer.position();
        int oldLim = this.buffer.limit();
        assert (this.lib.blockStart(this.filePos) == this.filePos);
        for (int i = 0; i < this.dirty.length; ++i) {
            int j;
            for (j = i; j < this.dirty.length && this.dirty[j]; ++j) {
                this.dirty[j] = false;
            }
            if (i == j) continue;
            this.buffer.position(i * this.lib.blockSize());
            this.buffer.limit(j * this.lib.blockSize());
            this.channel.write(this.buffer, this.filePos + (long)this.buffer.position());
            this.buffer.clear();
            i = j;
        }
        this.buffer.position(oldPos);
        this.buffer.limit(oldLim);
        this.globalDirty = false;
    }
}

