/*
 * Decompiled with CFR 0.152.
 */
package net.smacke.jaydio.align;

import java.io.File;
import java.io.IOException;
import net.smacke.jaydio.DirectIoLib;
import net.smacke.jaydio.align.ByteChannelAligner;
import net.smacke.jaydio.buffer.AlignedDirectByteBuffer;
import net.smacke.jaydio.channel.BufferedChannel;
import net.smacke.jaydio.channel.DirectIoByteChannel;

public class DirectIoByteChannelAligner
extends ByteChannelAligner<AlignedDirectByteBuffer> {
    public DirectIoByteChannelAligner(DirectIoLib lib, BufferedChannel<AlignedDirectByteBuffer> channel, AlignedDirectByteBuffer buffer) {
        super(lib, channel, buffer);
    }

    public static DirectIoByteChannelAligner open(File path) throws IOException {
        DirectIoLib lib = DirectIoLib.getLibForPath(path.toString());
        return DirectIoByteChannelAligner.open(lib, path, lib.defaultBufferSize(), false);
    }

    public static DirectIoByteChannelAligner open(File path, int bufferSize) throws IOException {
        DirectIoLib lib = DirectIoLib.getLibForPath(path.toString());
        return DirectIoByteChannelAligner.open(lib, path, bufferSize, false);
    }

    public static DirectIoByteChannelAligner open(File path, boolean readOnly) throws IOException {
        DirectIoLib lib = DirectIoLib.getLibForPath(path.toString());
        return DirectIoByteChannelAligner.open(lib, path, lib.defaultBufferSize(), readOnly);
    }

    public static DirectIoByteChannelAligner open(File path, int bufferSize, boolean readOnly) throws IOException {
        DirectIoLib lib = DirectIoLib.getLibForPath(path.toString());
        return DirectIoByteChannelAligner.open(lib, path, bufferSize, readOnly);
    }

    public static DirectIoByteChannelAligner open(DirectIoLib lib, File path, int bufferSize, boolean readOnly) throws IOException {
        if (bufferSize < 0 || bufferSize % lib.blockSize() != 0) {
            throw new IllegalArgumentException("The buffer capacity must be a multiple of the file system block size");
        }
        DirectIoByteChannel channel = DirectIoByteChannel.getChannel(lib, path, readOnly);
        AlignedDirectByteBuffer buffer = AlignedDirectByteBuffer.allocate(lib, bufferSize);
        return new DirectIoByteChannelAligner(lib, channel, buffer);
    }
}

