/*
 * Decompiled with CFR 0.152.
 */
package net.smacke.jaydio.buffer;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.smacke.jaydio.buffer.Buffer;

public abstract class AbstractBuffer
implements Buffer {
    protected int position = 0;
    protected int limit;
    protected int capacity;
    protected boolean isOpen;

    protected AbstractBuffer(int pos, int lim, int cap) {
        if (cap < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = cap;
        this.limit(lim);
        this.position(pos);
        this.isOpen = true;
    }

    @Override
    public final boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public AbstractBuffer position(int newPosition) {
        if (newPosition > this.limit || newPosition < 0) {
            throw new IllegalArgumentException();
        }
        this.position = newPosition;
        return this;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public AbstractBuffer limit(int newLimit) {
        if (newLimit > this.capacity || newLimit < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = newLimit;
        this.position = Math.min(this.position, this.limit);
        return this;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public AbstractBuffer rewind() {
        this.position = 0;
        return this;
    }

    @Override
    public AbstractBuffer flip() {
        this.limit = this.position;
        this.position = 0;
        return this;
    }

    @Override
    public AbstractBuffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        return this;
    }

    @Override
    public int remaining() {
        return this.limit - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.position < this.limit;
    }

    static void checkWithinBounds(int off, int len, int size) {
        if ((off | len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (off + len > size) {
            throw new IndexOutOfBoundsException();
        }
    }

    int safeIncrementForGet() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.position++;
    }

    int safeIncrementForPut() {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        return this.position++;
    }

    @Override
    public void close() {
        this.isOpen = false;
    }
}

