/*
 * Decompiled with CFR 0.152.
 */
package net.smacke.jaydio.buffer;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.smacke.jaydio.DirectIoLib;
import net.smacke.jaydio.buffer.AbstractBuffer;
import net.smacke.jaydio.buffer.JaydioByteBuffer;

public final class AlignedDirectByteBuffer
extends AbstractBuffer
implements JaydioByteBuffer {
    private Pointer pointer;
    private DirectIoLib lib;

    public static AlignedDirectByteBuffer allocate(DirectIoLib lib, int capacity) {
        if (capacity % lib.blockSize() > 0) {
            throw new IllegalArgumentException("Capacity (" + capacity + ") must be a multiple" + "of the block size (" + lib.blockSize() + ")");
        }
        NativeLong blockSize = new NativeLong((long)lib.blockSize());
        PointerByReference pointerToPointer = new PointerByReference();
        DirectIoLib.posix_memalign(pointerToPointer, blockSize, new NativeLong((long)capacity));
        return new AlignedDirectByteBuffer(lib, pointerToPointer.getValue(), 0, capacity, capacity);
    }

    private AlignedDirectByteBuffer(DirectIoLib lib, Pointer pointer, int pos, int lim, int cap) {
        super(pos, lim, cap);
        this.lib = lib;
        this.pointer = pointer;
    }

    @Override
    public AlignedDirectByteBuffer get(byte[] dst, int offset, int length) {
        AlignedDirectByteBuffer.checkWithinBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.pointer.read((long)this.position, dst, offset, length);
        this.position(this.position + length);
        return this;
    }

    @Override
    public AlignedDirectByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public AlignedDirectByteBuffer get(ByteBuffer dst) {
        int length = Math.min(this.remaining(), dst.remaining());
        this.get(dst.array(), dst.position(), length);
        dst.position(dst.position() + length);
        return this;
    }

    @Override
    public AlignedDirectByteBuffer put(byte[] src, int offset, int length) {
        AlignedDirectByteBuffer.checkWithinBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.pointer.write((long)this.position, src, offset, length);
        this.position(this.position + length);
        return this;
    }

    @Override
    public AlignedDirectByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public AlignedDirectByteBuffer put(ByteBuffer src) {
        int length = Math.min(this.remaining(), src.remaining());
        this.put(src.array(), src.position(), length);
        src.position(src.position() + length);
        return this;
    }

    @Override
    public byte get() {
        return this.pointer.getByte((long)this.safeIncrementForGet());
    }

    @Override
    public AlignedDirectByteBuffer put(byte b) {
        this.pointer.setByte((long)this.safeIncrementForPut(), b);
        return this;
    }

    @Override
    public AlignedDirectByteBuffer copy() {
        AlignedDirectByteBuffer copy = AlignedDirectByteBuffer.allocate(this.lib, this.capacity());
        int oldPos = this.position();
        int oldLim = this.limit();
        this.clear();
        byte[] temp = new byte[this.capacity()];
        this.get(temp);
        copy.put(temp);
        this.position(oldPos);
        copy.position(oldPos);
        this.limit(oldLim);
        copy.limit(oldLim);
        return copy;
    }

    public Pointer pointer() {
        return this.pointer.share(0L);
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        DirectIoLib.free(this.pointer);
        this.pointer = null;
    }
}

