/*
 * Decompiled with CFR 0.152.
 */
package net.smacke.jaydio.buffer;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.smacke.jaydio.buffer.AbstractBuffer;
import net.smacke.jaydio.buffer.JaydioByteBuffer;

public class JavaHeapByteBuffer
extends AbstractBuffer
implements JaydioByteBuffer {
    private byte[] backing;

    public static JavaHeapByteBuffer allocate(int capacity) {
        return new JavaHeapByteBuffer(0, capacity, capacity);
    }

    protected JavaHeapByteBuffer(int pos, int lim, int cap) {
        super(pos, lim, cap);
        this.backing = new byte[cap];
    }

    @Override
    public JavaHeapByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public JavaHeapByteBuffer put(byte[] src, int offset, int length) {
        JavaHeapByteBuffer.checkWithinBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.backing, this.position, length);
        this.position(this.position + length);
        return this;
    }

    @Override
    public JavaHeapByteBuffer put(ByteBuffer src) {
        int length = Math.min(this.remaining(), src.remaining());
        this.put(src.array(), src.position(), length);
        src.position(src.position() + length);
        return this;
    }

    @Override
    public JavaHeapByteBuffer put(byte b) {
        this.backing[this.safeIncrementForPut()] = b;
        return this;
    }

    @Override
    public byte get() {
        return this.backing[this.safeIncrementForGet()];
    }

    @Override
    public JavaHeapByteBuffer get(byte[] dst, int offset, int length) {
        JavaHeapByteBuffer.checkWithinBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.backing, this.position, dst, offset, length);
        this.position(this.position + length);
        return this;
    }

    @Override
    public JavaHeapByteBuffer get(ByteBuffer dst) {
        int length = Math.min(this.remaining(), dst.remaining());
        this.get(dst.array(), dst.position(), length);
        dst.position(dst.position() + length);
        return this;
    }

    @Override
    public JavaHeapByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public JavaHeapByteBuffer copy() {
        JavaHeapByteBuffer copy = new JavaHeapByteBuffer(this.position, this.limit, this.capacity);
        copy.backing = Arrays.copyOf(this.backing, this.backing.length);
        return copy;
    }

    @Override
    public void close() {
        if (!this.isOpen) {
            return;
        }
        this.isOpen = false;
        this.backing = null;
    }
}

