/*
 * Decompiled with CFR 0.152.
 */
package net.smacke.jaydio.channel;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import net.smacke.jaydio.DirectIoLib;
import net.smacke.jaydio.buffer.AlignedDirectByteBuffer;
import net.smacke.jaydio.channel.BufferedChannel;

public final class DirectIoByteChannel
implements BufferedChannel<AlignedDirectByteBuffer> {
    private DirectIoLib lib;
    private int fd;
    private boolean isOpen;
    private long fileLength;
    private boolean isReadOnly;

    public static DirectIoByteChannel getChannel(File file, boolean readOnly) throws IOException {
        DirectIoLib lib = DirectIoLib.getLibForPath(file.toString());
        return DirectIoByteChannel.getChannel(lib, file, readOnly);
    }

    public static DirectIoByteChannel getChannel(DirectIoLib lib, File file, boolean readOnly) throws IOException {
        int fd = lib.oDirectOpen(file.toString(), readOnly);
        long length = file.length();
        return new DirectIoByteChannel(lib, fd, length, readOnly);
    }

    private DirectIoByteChannel(DirectIoLib lib, int fd, long fileLength, boolean readOnly) {
        this.lib = lib;
        this.fd = fd;
        this.isOpen = true;
        this.isReadOnly = readOnly;
        this.fileLength = fileLength;
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void ensureWritable() {
        if (this.isReadOnly()) {
            throw new NonWritableChannelException();
        }
    }

    @Override
    public int read(AlignedDirectByteBuffer dst, long position) throws IOException {
        this.ensureOpen();
        return this.lib.pread(this.fd, dst, position);
    }

    @Override
    public int write(AlignedDirectByteBuffer src, long position) throws IOException {
        this.ensureOpen();
        this.ensureWritable();
        assert (src.position() == this.lib.blockStart(src.position()));
        int written = this.lib.pwrite(this.fd, src, position);
        this.fileLength = Math.max(position + (long)written, this.fileLength);
        return written;
    }

    public DirectIoByteChannel truncate(long length) throws IOException {
        this.ensureOpen();
        this.ensureWritable();
        if (DirectIoLib.ftruncate(this.fd, length) < 0) {
            throw new IOException("Error during truncate on descriptor " + this.fd + ": " + DirectIoLib.getLastError());
        }
        this.fileLength = length;
        return this;
    }

    @Override
    public long size() {
        return this.fileLength;
    }

    @Override
    public int getFD() {
        return this.fd;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            if (!this.isReadOnly()) {
                this.truncate(this.fileLength);
            }
        }
        finally {
            this.isOpen = false;
            if (this.lib.close(this.fd) < 0) {
                throw new IOException("Error closing file with descriptor " + this.fd + ": " + DirectIoLib.getLastError());
            }
        }
    }
}

