/*
 * Decompiled with CFR 0.152.
 */
package net.smacke.jaydio.channel;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import net.smacke.jaydio.DirectIoLib;
import net.smacke.jaydio.buffer.JaydioByteBuffer;
import net.smacke.jaydio.channel.BufferedChannel;

public final class MockByteChannel
implements BufferedChannel<JaydioByteBuffer> {
    private long fileLength;
    private boolean isOpen;
    private boolean isReadOnly;
    private byte[] file;

    public static MockByteChannel getChannel(long length, int blockSize, boolean readOnly) {
        return new MockByteChannel(DirectIoLib.blockEnd(blockSize, length), readOnly);
    }

    protected MockByteChannel(long fileLength, boolean readOnly) {
        this.isReadOnly = readOnly;
        this.isOpen = true;
        this.file = new byte[(int)fileLength];
        this.fileLength = readOnly ? fileLength : 0L;
    }

    @Override
    public int read(JaydioByteBuffer dst, long position) throws ClosedChannelException {
        this.ensureOpen();
        dst.clear();
        int endPos = Math.min((int)position + dst.limit(), (int)this.size());
        for (int i = (int)position; i < endPos; ++i) {
            dst.put(this.file[i]);
        }
        dst.clear();
        return (int)((long)endPos - position);
    }

    @Override
    public int write(JaydioByteBuffer src, long position) throws IOException {
        this.ensureOpen();
        this.ensureWritable();
        int oldPos = src.position();
        src.position(0);
        int i = (int)position;
        while ((long)i < position + (long)src.limit()) {
            this.file[i] = src.get();
            ++i;
        }
        this.fileLength = Math.max(position + (long)src.limit(), this.fileLength);
        src.position(oldPos);
        return src.limit();
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
    }

    private void ensureWritable() throws NonWritableChannelException {
        if (this.isReadOnly) {
            throw new NonWritableChannelException();
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public long size() {
        return this.fileLength;
    }

    public MockByteChannel truncate(long fileLength) throws IOException {
        this.ensureOpen();
        this.ensureWritable();
        this.fileLength = fileLength;
        return this;
    }

    @Override
    public int getFD() {
        throw new UnsupportedOperationException("mock channel is not backed by file");
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }
}

