/*
 * Decompiled with CFR 0.152.
 */
package net.smartam.leeloo.client.request;

import java.util.HashMap;
import java.util.Map;
import net.smartam.leeloo.client.request.ClientHeaderParametersApplier;
import net.smartam.leeloo.common.exception.OAuthSystemException;
import net.smartam.leeloo.common.message.OAuthMessage;
import net.smartam.leeloo.common.message.types.GrantType;
import net.smartam.leeloo.common.parameters.BodyURLEncodedParametersApplier;
import net.smartam.leeloo.common.parameters.OAuthParametersApplier;
import net.smartam.leeloo.common.parameters.QueryParameterApplier;

public class OAuthClientRequest
implements OAuthMessage {
    protected String url;
    protected String body;
    protected Map<String, String> headers;

    protected OAuthClientRequest(String url) {
        this.url = url;
    }

    public static AuthenticationRequestBuilder authorizationLocation(String url) {
        return new AuthenticationRequestBuilder(url);
    }

    public static TokenRequestBuilder tokenLocation(String url) {
        return new TokenRequestBuilder(url);
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void addHeader(String name, String header) {
        this.headers.put(name, header);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getLocationUri() {
        return this.url;
    }

    public void setLocationUri(String uri) {
        this.url = uri;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public static class TokenRequestBuilder
    extends OAuthRequestBuilder {
        public TokenRequestBuilder(String url) {
            super(url);
        }

        public TokenRequestBuilder setGrantType(GrantType grantType) {
            this.parameters.put("grant_type", grantType.toString());
            return this;
        }

        public TokenRequestBuilder setClientId(String clientId) {
            this.parameters.put("client_id", clientId);
            return this;
        }

        public TokenRequestBuilder setClientSecret(String secret) {
            this.parameters.put("client_secret", secret);
            return this;
        }

        public TokenRequestBuilder setUsername(String username) {
            this.parameters.put("username", username);
            return this;
        }

        public TokenRequestBuilder setPassword(String password) {
            this.parameters.put("password", password);
            return this;
        }

        public TokenRequestBuilder setScope(String scope) {
            this.parameters.put("scope", scope);
            return this;
        }

        public TokenRequestBuilder setCode(String code) {
            this.parameters.put("code", code);
            return this;
        }

        public TokenRequestBuilder setRedirectURI(String uri) {
            this.parameters.put("redirect_uri", uri);
            return this;
        }

        public TokenRequestBuilder setAssertion(String assertion) {
            this.parameters.put("assertion", assertion);
            return this;
        }

        public TokenRequestBuilder setAssertionType(String assertionType) {
            this.parameters.put("assertion_type", assertionType);
            return this;
        }

        public TokenRequestBuilder setRefreshToken(String token) {
            this.parameters.put("refresh_token", token);
            return this;
        }

        public TokenRequestBuilder setParameter(String paramName, String paramValue) {
            this.parameters.put(paramName, paramValue);
            return this;
        }
    }

    public static class AuthenticationRequestBuilder
    extends OAuthRequestBuilder {
        public AuthenticationRequestBuilder(String url) {
            super(url);
        }

        public AuthenticationRequestBuilder setResponseType(String type) {
            this.parameters.put("response_type", type);
            return this;
        }

        public AuthenticationRequestBuilder setClientId(String clientId) {
            this.parameters.put("client_id", clientId);
            return this;
        }

        public AuthenticationRequestBuilder setRedirectURI(String uri) {
            this.parameters.put("redirect_uri", uri);
            return this;
        }

        public AuthenticationRequestBuilder setState(String state) {
            this.parameters.put("state", state);
            return this;
        }

        public AuthenticationRequestBuilder setScope(String scope) {
            this.parameters.put("scope", scope);
            return this;
        }

        public AuthenticationRequestBuilder setParameter(String paramName, String paramValue) {
            this.parameters.put(paramName, paramValue);
            return this;
        }
    }

    public static abstract class OAuthRequestBuilder {
        protected OAuthParametersApplier applier;
        protected Map<String, String> parameters = new HashMap<String, String>();
        protected String url;

        protected OAuthRequestBuilder(String url) {
            this.url = url;
        }

        public OAuthClientRequest buildQueryMessage() throws OAuthSystemException {
            OAuthClientRequest request = new OAuthClientRequest(this.url);
            this.applier = new QueryParameterApplier();
            return (OAuthClientRequest)this.applier.applyOAuthParameters((OAuthMessage)request, this.parameters);
        }

        public OAuthClientRequest buildBodyMessage() throws OAuthSystemException {
            OAuthClientRequest request = new OAuthClientRequest(this.url);
            this.applier = new BodyURLEncodedParametersApplier();
            return (OAuthClientRequest)this.applier.applyOAuthParameters((OAuthMessage)request, this.parameters);
        }

        public OAuthClientRequest buildHeaderMessage() throws OAuthSystemException {
            OAuthClientRequest request = new OAuthClientRequest(this.url);
            this.applier = new ClientHeaderParametersApplier();
            return (OAuthClientRequest)this.applier.applyOAuthParameters((OAuthMessage)request, this.parameters);
        }
    }
}

