/*
 * Decompiled with CFR 0.152.
 */
package net.smartam.leeloo.client.response;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.smartam.leeloo.client.response.OAuthClientResponse;
import net.smartam.leeloo.client.validator.CodeTokenValidator;
import net.smartam.leeloo.client.validator.CodeValidator;
import net.smartam.leeloo.client.validator.OAuthClientValidator;
import net.smartam.leeloo.client.validator.TokenValidator;
import net.smartam.leeloo.common.exception.OAuthProblemException;
import net.smartam.leeloo.common.utils.OAuthUtils;

public class OAuthAuthzResponse
extends OAuthClientResponse {
    protected OAuthAuthzResponse(HttpServletRequest request, OAuthClientValidator validator) {
        Map params = request.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (OAuthUtils.hasEmptyValues((String[])values)) continue;
            this.parameters.put(key, values[0]);
        }
        this.validator = validator;
    }

    public static OAuthAuthzResponse oauthCodeAuthzResponse(HttpServletRequest request) throws OAuthProblemException {
        OAuthAuthzResponse response = new OAuthAuthzResponse(request, new CodeValidator());
        response.validate();
        return response;
    }

    public static OAuthAuthzResponse oAuthCodeAndTokenAuthzResponse(HttpServletRequest request) throws OAuthProblemException {
        OAuthAuthzResponse response = new OAuthAuthzResponse(request, new CodeTokenValidator());
        response.validate();
        return response;
    }

    public static OAuthAuthzResponse oauthTokenAuthzResponse(HttpServletRequest request) throws OAuthProblemException {
        OAuthAuthzResponse response = new OAuthAuthzResponse(request, new TokenValidator());
        response.validate();
        return response;
    }

    public String getAccessToken() {
        return this.getParam("access_token");
    }

    public String getExpiresIn() {
        return this.getParam("expires_in");
    }

    public String getScope() {
        return this.getParam("scope");
    }

    public String getCode() {
        return this.getParam("code");
    }

    public String getState() {
        return this.getParam("state");
    }

    @Override
    public String getParam(String key) {
        return (String)this.parameters.get(key);
    }

    @Override
    protected void setBody(String body) {
        this.body = body;
    }

    @Override
    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    protected void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }
}

