/*
 * Decompiled with CFR 0.152.
 */
package net.smartam.leeloo.common.message;

import java.util.HashMap;
import java.util.Map;
import net.smartam.leeloo.common.exception.OAuthProblemException;
import net.smartam.leeloo.common.exception.OAuthSystemException;
import net.smartam.leeloo.common.message.OAuthMessage;
import net.smartam.leeloo.common.parameters.BodyURLEncodedParametersApplier;
import net.smartam.leeloo.common.parameters.JSONBodyParametersApplier;
import net.smartam.leeloo.common.parameters.OAuthParametersApplier;
import net.smartam.leeloo.common.parameters.QueryParameterApplier;
import net.smartam.leeloo.common.parameters.WWWAuthHeaderParametersApplier;

public class OAuthResponse
implements OAuthMessage {
    protected int responseStatus;
    protected String uri;
    protected String body;
    protected Map<String, String> headers = new HashMap<String, String>();

    protected OAuthResponse(String uri, int responseStatus) {
        this.uri = uri;
        this.responseStatus = responseStatus;
    }

    public static OAuthResponseBuilder status(int code) {
        return new OAuthResponseBuilder(code);
    }

    public static OAuthErrorResponseBuilder errorResponse(int code) {
        return new OAuthErrorResponseBuilder(code);
    }

    @Override
    public String getLocationUri() {
        return this.uri;
    }

    @Override
    public void setLocationUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public void setBody(String body) {
        this.body = body;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    @Override
    public void addHeader(String name, String header) {
        this.headers.put(name, header);
    }

    public static class OAuthErrorResponseBuilder
    extends OAuthResponseBuilder {
        public OAuthErrorResponseBuilder(int responseCode) {
            super(responseCode);
        }

        public OAuthErrorResponseBuilder error(OAuthProblemException ex) {
            this.parameters.put("error", ex.getError());
            this.parameters.put("error_description", ex.getDescription());
            this.parameters.put("error_uri", ex.getUri());
            this.parameters.put("state", ex.getState());
            return this;
        }

        public OAuthErrorResponseBuilder setError(String error) {
            this.parameters.put("error", error);
            return this;
        }

        public OAuthErrorResponseBuilder setErrorDescription(String desc) {
            this.parameters.put("error_description", desc);
            return this;
        }

        public OAuthErrorResponseBuilder setErrorUri(String state) {
            this.parameters.put("error_uri", state);
            return this;
        }

        public OAuthErrorResponseBuilder setState(String state) {
            this.parameters.put("state", state);
            return this;
        }

        public OAuthErrorResponseBuilder setRealm(String realm) {
            this.parameters.put("realm", realm);
            return this;
        }

        @Override
        public OAuthErrorResponseBuilder location(String location) {
            this.location = location;
            return this;
        }
    }

    public static class OAuthResponseBuilder {
        protected OAuthParametersApplier applier;
        protected Map<String, String> parameters = new HashMap<String, String>();
        protected int responseCode;
        protected String location;

        public OAuthResponseBuilder(int responseCode) {
            this.responseCode = responseCode;
        }

        public OAuthResponseBuilder location(String location) {
            this.location = location;
            return this;
        }

        public OAuthResponseBuilder setScope(String value) {
            this.parameters.put("scope", value);
            return this;
        }

        public OAuthResponseBuilder setParam(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }

        public OAuthResponse buildQueryMessage() throws OAuthSystemException {
            OAuthResponse msg = new OAuthResponse(this.location, this.responseCode);
            this.applier = new QueryParameterApplier();
            return (OAuthResponse)this.applier.applyOAuthParameters(msg, this.parameters);
        }

        public OAuthResponse buildBodyMessage() throws OAuthSystemException {
            OAuthResponse msg = new OAuthResponse(this.location, this.responseCode);
            this.applier = new BodyURLEncodedParametersApplier();
            return (OAuthResponse)this.applier.applyOAuthParameters(msg, this.parameters);
        }

        public OAuthResponse buildJSONMessage() throws OAuthSystemException {
            OAuthResponse msg = new OAuthResponse(this.location, this.responseCode);
            this.applier = new JSONBodyParametersApplier();
            return (OAuthResponse)this.applier.applyOAuthParameters(msg, this.parameters);
        }

        public OAuthResponse buildHeaderMessage() throws OAuthSystemException {
            OAuthResponse msg = new OAuthResponse(this.location, this.responseCode);
            this.applier = new WWWAuthHeaderParametersApplier();
            return (OAuthResponse)this.applier.applyOAuthParameters(msg, this.parameters);
        }
    }
}

