/*
 * Decompiled with CFR 0.152.
 */
package net.smartam.leeloo.common.parameters;

import java.util.HashMap;
import java.util.Map;
import net.smartam.leeloo.common.message.OAuthMessage;
import net.smartam.leeloo.common.parameters.OAuthParametersApplier;
import net.smartam.leeloo.common.utils.OAuthUtils;

public class QueryParameterApplier
implements OAuthParametersApplier {
    @Override
    public OAuthMessage applyOAuthParameters(OAuthMessage message, Map<String, String> params) {
        String messageUrl = message.getLocationUri();
        if (messageUrl != null) {
            boolean containsQuestionMark = messageUrl.contains("?");
            StringBuffer url = new StringBuffer(messageUrl);
            HashMap<String, String> fragmentParams = new HashMap<String, String>();
            if (params.containsKey("access_token")) {
                fragmentParams.put("access_token", params.remove("access_token"));
                if (params.containsKey("expires_in")) {
                    fragmentParams.put("expires_in", params.remove("expires_in"));
                }
            }
            StringBuffer query = new StringBuffer(OAuthUtils.format(params.entrySet(), "UTF-8"));
            String fragmentQuery = "";
            if (fragmentParams.containsKey("access_token")) {
                fragmentQuery = OAuthUtils.format(fragmentParams.entrySet(), "UTF-8");
            }
            if (!OAuthUtils.isEmpty(query.toString())) {
                if (containsQuestionMark) {
                    url.append("&").append(query);
                } else {
                    url.append("?").append(query);
                }
            }
            if (!OAuthUtils.isEmpty(fragmentQuery)) {
                url.append("#").append(fragmentQuery);
            }
            message.setLocationUri(url.toString());
        }
        return message;
    }
}

