/*
 * Decompiled with CFR 0.152.
 */
package net.smartam.leeloo.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.smartam.leeloo.common.exception.OAuthProblemException;
import net.smartam.leeloo.common.exception.OAuthSystemException;

public final class OAuthUtils {
    private static final String ENCODING = "UTF-8";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    public static final String AUTH_SCHEME = "OAuth";
    private static final Pattern OAUTH_HEADER = Pattern.compile("\\s*(\\w*)\\s+(.*)");
    private static final Pattern NVP = Pattern.compile("(\\S*)\\s*\\=\\s*\"([^\"]*)\"");
    public static final String MULTIPART = "multipart/";

    public static String format(Collection<? extends Map.Entry<String, String>> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters) {
            String encodedValue;
            if (OAuthUtils.isEmpty(entry.getKey()) || OAuthUtils.isEmpty(entry.getValue())) continue;
            String encodedName = OAuthUtils.encode(entry.getKey(), encoding);
            String value = entry.getValue();
            String string = encodedValue = value != null ? OAuthUtils.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append(PARAMETER_SEPARATOR);
            }
            result.append(encodedName);
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : ENCODING);
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    public static String saveStreamAsString(InputStream is) {
        if (is != null) {
            InputStreamReader ir = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] buffer = new char[1000];
            try {
                while (ir.read(buffer) != -1) {
                    sb.append(buffer);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String string = sb.toString();
            return string.trim();
        }
        return null;
    }

    public static OAuthProblemException handleOAuthProblemException(String message) {
        return OAuthProblemException.error("invalid_request").description(message);
    }

    public static OAuthProblemException handleMissingParameters(Set<String> missingParams) {
        StringBuffer sb = new StringBuffer("Missing parameters: ");
        if (!OAuthUtils.isEmpty(missingParams)) {
            for (String missingParam : missingParams) {
                sb.append(missingParam).append(" ");
            }
        }
        return OAuthUtils.handleOAuthProblemException(sb.toString().trim());
    }

    private static boolean isEmpty(Set<String> missingParams) {
        return missingParams == null || missingParams.size() == 0;
    }

    public static OAuthProblemException handleNotAllowedParametersOAuthException(List<String> notAllowedParams) {
        StringBuffer sb = new StringBuffer("Not allowed parameters: ");
        if (notAllowedParams != null) {
            for (String notAllowed : notAllowedParams) {
                sb.append(notAllowed).append(" ");
            }
        }
        return OAuthUtils.handleOAuthProblemException(sb.toString().trim());
    }

    public static Map<String, String> decodeForm(String form) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!OAuthUtils.isEmpty(form)) {
            for (String nvp : form.split("\\&")) {
                String value;
                String name;
                int equals = nvp.indexOf(61);
                if (equals < 0) {
                    name = OAuthUtils.decodePercent(nvp);
                    value = null;
                } else {
                    name = OAuthUtils.decodePercent(nvp.substring(0, equals));
                    value = OAuthUtils.decodePercent(nvp.substring(equals + 1));
                }
                params.put(name, value);
            }
        }
        return params;
    }

    public static boolean isFormEncoded(String contentType) {
        if (contentType == null) {
            return false;
        }
        int semi = contentType.indexOf(";");
        if (semi >= 0) {
            contentType = contentType.substring(0, semi);
        }
        return "application/x-www-form-urlencoded".equalsIgnoreCase(contentType.trim());
    }

    public static String decodePercent(String s) {
        try {
            return URLDecoder.decode(s, ENCODING);
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    public static String percentEncode(Iterable values) {
        StringBuilder p = new StringBuilder();
        for (Object v : values) {
            String stringValue = OAuthUtils.toString(v);
            if (OAuthUtils.isEmpty(stringValue)) continue;
            if (p.length() > 0) {
                p.append(PARAMETER_SEPARATOR);
            }
            p.append(OAuthUtils.percentEncode(OAuthUtils.toString(v)));
        }
        return p.toString();
    }

    public static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    private static final String toString(Object from) {
        return from == null ? null : from.toString();
    }

    public static Object instantiateClass(Class clazz) throws OAuthSystemException {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new OAuthSystemException(e);
        }
    }

    public static Object instantiateClassWithParameters(Class clazz, Class[] paramsTypes, Object[] paramValues) throws OAuthSystemException {
        try {
            if (paramsTypes != null && paramValues != null) {
                if (paramsTypes.length != paramValues.length) {
                    throw new IllegalArgumentException("Number of types and values must be equal");
                }
                if (paramsTypes.length == 0 && paramValues.length == 0) {
                    return clazz.newInstance();
                }
                Constructor clazzConstructor = clazz.getConstructor(paramsTypes);
                return clazzConstructor.newInstance(paramValues);
            }
            return clazz.newInstance();
        }
        catch (NoSuchMethodException e) {
            throw new OAuthSystemException(e);
        }
        catch (InstantiationException e) {
            throw new OAuthSystemException(e);
        }
        catch (IllegalAccessException e) {
            throw new OAuthSystemException(e);
        }
        catch (InvocationTargetException e) {
            throw new OAuthSystemException(e);
        }
    }

    public static String getAuthHeaderField(String authHeader) {
        Matcher m;
        if (authHeader != null && (m = OAUTH_HEADER.matcher(authHeader)).matches() && AUTH_SCHEME.equalsIgnoreCase(m.group(1))) {
            return m.group(2);
        }
        return null;
    }

    public static Map<String, String> decodeOAuthHeader(String header) {
        Matcher m;
        HashMap<String, String> headerValues = new HashMap<String, String>();
        if (header != null && (m = OAUTH_HEADER.matcher(header)).matches() && AUTH_SCHEME.equalsIgnoreCase(m.group(1))) {
            for (String nvp : m.group(2).split("\\s*,\\s*")) {
                m = NVP.matcher(nvp);
                if (!m.matches()) continue;
                String name = OAuthUtils.decodePercent(m.group(1));
                String value = OAuthUtils.decodePercent(m.group(2));
                headerValues.put(name, value);
            }
        }
        return headerValues;
    }

    public static String encodeOAuthHeader(Map<String, String> entries) {
        StringBuffer sb = new StringBuffer();
        sb.append(AUTH_SCHEME).append(" ");
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            if (OAuthUtils.isEmpty(entry.getKey()) || OAuthUtils.isEmpty(entry.getValue())) continue;
            sb.append(entry.getKey());
            sb.append("=\"");
            sb.append(entry.getValue());
            sb.append("\",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public static boolean hasEmptyValues(String[] array) {
        if (array == null || array.length == 0) {
            return true;
        }
        for (String s : array) {
            if (!OAuthUtils.isEmpty(s)) continue;
            return true;
        }
        return false;
    }

    public static String getAuthzMethod(String header) {
        Matcher m;
        if (header != null && (m = OAUTH_HEADER.matcher(header)).matches()) {
            return m.group(1);
        }
        return null;
    }

    public static Set<String> decodeScopes(String s) {
        HashSet<String> scopes = new HashSet<String>();
        if (!OAuthUtils.isEmpty(s)) {
            StringTokenizer tokenizer = new StringTokenizer(s, " ");
            while (tokenizer.hasMoreElements()) {
                scopes.add(tokenizer.nextToken());
            }
        }
        return scopes;
    }

    public static String encodeScopes(Set<String> s) {
        StringBuffer scopes = new StringBuffer();
        for (String scope : s) {
            scopes.append(scope).append(" ");
        }
        return scopes.toString().trim();
    }

    public static boolean isMultipart(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public static boolean hasContentType(String requestContentType, String requiredContentType) {
        if (OAuthUtils.isEmpty(requiredContentType) || OAuthUtils.isEmpty(requestContentType)) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(requestContentType, ";");
        while (tokenizer.hasMoreTokens()) {
            if (!requiredContentType.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }
}

