/*
 * Decompiled with CFR 0.152.
 */
package net.smartam.leeloo.common.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.smartam.leeloo.common.exception.OAuthProblemException;
import net.smartam.leeloo.common.utils.OAuthUtils;
import net.smartam.leeloo.common.validators.OAuthValidator;

public abstract class AbstractValidator
implements OAuthValidator {
    protected List<String> requiredParams = new ArrayList<String>();
    protected Map<String, String[]> optionalParams = new HashMap<String, String[]>();
    protected List<String> notAllowedParams = new ArrayList<String>();

    @Override
    public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
        if (!request.getMethod().equals("POST")) {
            throw OAuthUtils.handleOAuthProblemException("Method not set to POST.");
        }
    }

    @Override
    public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
        String contentType = request.getContentType();
        if (!OAuthUtils.hasContentType(contentType, "application/x-www-form-urlencoded")) {
            throw OAuthUtils.handleOAuthProblemException("Bad content type.");
        }
    }

    @Override
    public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
        HashSet<String> missingParameters = new HashSet<String>();
        for (String requiredParam : this.requiredParams) {
            String val = request.getParameter(requiredParam);
            if (!OAuthUtils.isEmpty(val)) continue;
            missingParameters.add(requiredParam);
        }
        if (!missingParameters.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(missingParameters);
        }
    }

    @Override
    public void validateOptionalParameters(HttpServletRequest request) throws OAuthProblemException {
        HashSet<String> missingParameters = new HashSet<String>();
        for (Map.Entry<String, String[]> requiredParam : this.optionalParams.entrySet()) {
            String[] dependentParams;
            String paramName = requiredParam.getKey();
            String val = request.getParameter(paramName);
            if (OAuthUtils.isEmpty(val) || OAuthUtils.hasEmptyValues(dependentParams = requiredParam.getValue())) continue;
            for (String dependentParam : dependentParams) {
                val = request.getParameter(dependentParam);
                if (!OAuthUtils.isEmpty(val)) continue;
                missingParameters.add(dependentParam);
            }
        }
        if (!missingParameters.isEmpty()) {
            throw OAuthUtils.handleMissingParameters(missingParameters);
        }
    }

    @Override
    public void validateNotAllowedParameters(HttpServletRequest request) throws OAuthProblemException {
        ArrayList<String> notAllowedParameters = new ArrayList<String>();
        for (String requiredParam : this.notAllowedParams) {
            String val = request.getParameter(requiredParam);
            if (OAuthUtils.isEmpty(val)) continue;
            notAllowedParameters.add(requiredParam);
        }
        if (!notAllowedParameters.isEmpty()) {
            throw OAuthUtils.handleNotAllowedParametersOAuthException(notAllowedParameters);
        }
    }

    @Override
    public void performAllValidations(HttpServletRequest request) throws OAuthProblemException {
        this.validateContentType(request);
        this.validateMethod(request);
        this.validateRequiredParameters(request);
        this.validateOptionalParameters(request);
        this.validateNotAllowedParameters(request);
    }
}

