/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.cluster.gateway;

import java.net.URI;
import net.smartcosmos.cluster.gateway.AuthenticationClient;
import net.smartcosmos.cluster.gateway.config.AuthenticationServerConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@EnableConfigurationProperties(value={AuthenticationServerConnectionProperties.class})
public class AuthenticationClientDefault
implements AuthenticationClient {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationClientDefault.class);
    private final AuthenticationServerConnectionProperties authServerConnectionProperties;
    private RestTemplate authServerRestTemplate;

    @Autowired
    public AuthenticationClientDefault(@Qualifier(value="authServerRestTemplate") RestTemplate authServerRestTemplate, AuthenticationServerConnectionProperties authServerConnectionProperties) {
        this.authServerRestTemplate = authServerRestTemplate;
        this.authServerConnectionProperties = authServerConnectionProperties;
    }

    @Override
    public OAuth2AccessToken getOauthToken(String username, String password) throws AuthenticationException {
        String authServerUri = this.authServerConnectionProperties.getLocationUri();
        URI uri = UriComponentsBuilder.fromHttpUrl((String)authServerUri).pathSegment(new String[]{"oauth/token"}).queryParam("grant_type", new Object[]{"password"}).queryParam("username", new Object[]{username}).queryParam("password", new Object[]{password}).build().toUri();
        log.debug("Connecting to {} using username: {} to authenticate user.", (Object)authServerUri, (Object)username);
        try {
            return (OAuth2AccessToken)this.authServerRestTemplate.postForObject(uri, null, OAuth2AccessToken.class);
        }
        catch (RestClientException e) {
            String message = String.format("Authenticating user %s with request %s failed: %s", username, uri.toString().replace("password=" + password, "password=[PROTECTED]"), e.toString());
            log.warn(message);
            log.debug(message, (Throwable)e);
            throw new InternalAuthenticationServiceException(message, (Throwable)e);
        }
    }
}

