/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.cluster.gateway.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import net.smartcosmos.cluster.gateway.config.AuthenticationServerConnectionProperties;
import net.smartcosmos.cluster.gateway.rest.AuthenticationErrorHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.context.embedded.undertow.UndertowEmbeddedServletContainerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.ribbon.RibbonClientHttpRequestFactory;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.security.config.annotation.authentication.configuration.EnableGlobalAuthentication;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Base64Utils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableGlobalAuthentication
@EnableConfigurationProperties(value={AuthenticationServerConnectionProperties.class})
@Profile(value={"!test"})
public class GatewayConfiguration
extends GlobalAuthenticationConfigurerAdapter {
    @Autowired
    private AuthenticationServerConnectionProperties securityResourceProperties;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public RibbonClientHttpRequestFactory ribbonClientHttpRequestFactory(SpringClientFactory clientFactory) {
        return new RibbonClientHttpRequestFactory(clientFactory);
    }

    @Bean
    public UndertowEmbeddedServletContainerFactory embeddedServletContainerFactory() {
        UndertowEmbeddedServletContainerFactory factory = new UndertowEmbeddedServletContainerFactory();
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> deploymentInfo.setAllowNonStandardWrappers(true)});
        return factory;
    }

    @Bean
    @Autowired
    public RestTemplate authServerRestTemplate(RibbonClientHttpRequestFactory ribbonClientHttpRequestFactory, AuthenticationErrorHandler authenticationErrorHandler, AuthenticationServerConnectionProperties authServerConnectionProperties) {
        List<BasicAuthorizationInterceptor> interceptors = Collections.singletonList(new BasicAuthorizationInterceptor(authServerConnectionProperties.getName(), authServerConnectionProperties.getPassword()));
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new InterceptingClientHttpRequestFactory((ClientHttpRequestFactory)ribbonClientHttpRequestFactory, interceptors));
        restTemplate.setErrorHandler((ResponseErrorHandler)authenticationErrorHandler);
        return restTemplate;
    }

    private static class BasicAuthorizationInterceptor
    implements ClientHttpRequestInterceptor {
        private static final String BASIC_AUTHENTICATION_HEADER = "Basic ";
        private final String username;
        private final String password;

        BasicAuthorizationInterceptor(String username, String password) {
            this.username = username;
            this.password = password == null ? "" : password;
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            String token = Base64Utils.encodeToString((byte[])(this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
            request.getHeaders().add("Authorization", BASIC_AUTHENTICATION_HEADER + token);
            return execution.execute(request, body);
        }
    }
}

