/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.cluster.gateway.filters;

import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.ZuulFilterResult;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.util.HTTPRequestUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import net.smartcosmos.cluster.gateway.AuthenticationClient;
import net.smartcosmos.cluster.gateway.domain.ErrorResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UrlPathHelper;

@Service
@ConditionalOnProperty(prefix="smartcosmos.gateway.pre-authorization-filter", name={"enabled"}, matchIfMissing=true)
public class PreAuthorizationFilter
extends ZuulFilter {
    private static final Logger log = LoggerFactory.getLogger(PreAuthorizationFilter.class);
    private static final String FILTER_TYPE_PRE = "pre";
    private static final Integer FILTER_ORDER = 2;
    private static final String BASIC_AUTHENTICATION_TYPE = "Basic";
    private static final String REQUEST_PATH_OAUTH = "oauth";
    private static final String LOCAL_HANDLING_PREFIX = "forward:";
    private final AuthenticationClient authenticationClient;
    private final RouteLocator routeLocator;
    private final UrlPathHelper urlPathHelper;

    @Autowired
    public PreAuthorizationFilter(AuthenticationClient authenticationClient, RouteLocator routeLocator) {
        this.authenticationClient = authenticationClient;
        this.routeLocator = routeLocator;
        this.urlPathHelper = new UrlPathHelper();
    }

    public String filterType() {
        return FILTER_TYPE_PRE;
    }

    public int filterOrder() {
        return FILTER_ORDER;
    }

    public boolean shouldFilter() {
        return !this.isForwardingRoute() && !this.isAuthorizationPath() && this.isBasicAuthRequest();
    }

    public boolean isForwardingRoute() {
        String requestUri = this.urlPathHelper.getPathWithinApplication(this.getRequest());
        Route route = this.routeLocator.getMatchingRoute(requestUri);
        if (route != null && StringUtils.isNotBlank((String)route.getLocation())) {
            return route.getLocation().startsWith(LOCAL_HANDLING_PREFIX);
        }
        return false;
    }

    public boolean isBasicAuthRequest() {
        return org.apache.commons.lang3.StringUtils.startsWith((CharSequence)HTTPRequestUtils.getInstance().getHeaderValue("Authorization"), (CharSequence)BASIC_AUTHENTICATION_TYPE);
    }

    public boolean isAuthorizationPath() {
        String path = this.getRequest().getRequestURI();
        return org.apache.commons.lang3.StringUtils.startsWith((CharSequence)path, (CharSequence)REQUEST_PATH_OAUTH) || org.apache.commons.lang3.StringUtils.startsWith((CharSequence)path, (CharSequence)"/oauth");
    }

    protected HttpServletRequest getRequest() {
        RequestContext ctx = RequestContext.getCurrentContext();
        return ctx.getRequest();
    }

    public Object run() {
        String[] authCredentials = null;
        try {
            authCredentials = this.getAuthenticationCredentials();
            OAuth2AccessToken oauthToken = this.authenticationClient.getOauthToken(authCredentials[0], authCredentials[1]);
            RequestContext ctx = RequestContext.getCurrentContext();
            ctx.addZuulRequestHeader("Authorization", "Bearer " + oauthToken.getValue());
        }
        catch (BadCredentialsException e) {
            log.warn("Authentication request failed. User: '{}', Cause: '{}'", (Object)authCredentials[0], (Object)e.getMessage());
            this.setErrorResponse(HttpStatus.UNAUTHORIZED, "Access Denied");
        }
        catch (Throwable throwable) {
            log.warn("Exception processing authentication request. user: '{}', cause: '{}'", (Object)(authCredentials != null && authCredentials.length == 2 ? authCredentials[0] : ArrayUtils.toString((Object)authCredentials)), (Object)throwable.toString());
            return new ZuulFilterResult(ExecutionStatus.FAILED);
        }
        return new ZuulFilterResult(ExecutionStatus.SUCCESS);
    }

    protected String[] getAuthenticationCredentials() {
        HttpServletRequest request = this.getRequest();
        String base64Credentials = request.getHeader("Authorization").substring(BASIC_AUTHENTICATION_TYPE.length()).trim();
        String decodedCredentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
        return decodedCredentials.split(":", 2);
    }

    protected void setErrorResponse(HttpStatus statusCode, String message) {
        RequestContext ctx = RequestContext.getCurrentContext();
        ctx.setResponseStatusCode(statusCode.value());
        ctx.addZuulResponseHeader("Content-Type", "application/json;charset=UTF-8");
        if (ctx.getResponseBody() == null) {
            ctx.setResponseBody(this.getResponseBody(statusCode, message, this.getRequest().getServletPath()));
            ctx.setSendZuulResponse(false);
        }
    }

    protected String getResponseBody(HttpStatus statusCode, String message, String path) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            ErrorResponse responseBody = ErrorResponse.builder().timestamp(System.currentTimeMillis()).status(statusCode.value()).error(statusCode.getReasonPhrase()).message(message).path(path).build();
            return objectMapper.writeValueAsString((Object)responseBody);
        }
        catch (IOException e) {
            return String.format("{\"message\": \"%s\"}", message);
        }
    }
}

