/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.cluster.gateway.resource;

import com.netflix.client.ClientException;
import com.netflix.zuul.context.RequestContext;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import net.smartcosmos.cluster.gateway.domain.ErrorResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ResponseBody
@PreAuthorize(value="permitAll()")
public class GatewayErrorController
implements ErrorController {
    private static final Logger log = LoggerFactory.getLogger(GatewayErrorController.class);
    public static final String ERROR_PATH = "/error";
    public static final String ATTR_ERROR_EXCEPTION = "error.exception";
    public static final String ATTR_ERROR_MESSAGE = "error.message";
    public static final String ATTR_ERROR_STATUS_CODE = "error.status_code";
    public static final String ATTR_PROXY = "proxy";
    public static final String ATTR_SERVICE_ID = "serviceId";
    public static final String ZUUL_REQUEST_URI = "requestURI";
    public static final String ERROR_MESSAGE_GENERAL = "GENERAL";
    public static final String ERROR_MESSAGE_TIMEOUT = "TIMEOUT";

    @RequestMapping(value={"/error"})
    public ResponseEntity<?> error() {
        String errorResponseMessage;
        String requestUri = null;
        RequestContext requestContext = this.getCurrentContext();
        if (MapUtils.isEmpty((Map)requestContext)) {
            String msg = "No context information available. A reason for this can be that no configured route matched the request.";
            log.warn(msg);
            return this.errorResponse(HttpStatus.INTERNAL_SERVER_ERROR, msg, null);
        }
        try {
            requestUri = this.getRequestUriFromRequestContext(requestContext);
            HttpStatus httpStatus = this.getHttpStatusFromRequestContext(requestContext);
            String route = this.getRouteFromRequestContext(requestContext);
            String serviceId = this.getServiceIdFromRequestContext(requestContext);
            String errorMessage = this.getErrorMessageFromRequestContext(requestContext);
            Exception errorException = this.getExceptionFromRequestContext(requestContext);
            String exceptionMessage = "No message available";
            Throwable rootCause = null;
            if (errorException != null) {
                exceptionMessage = errorException.getMessage();
                rootCause = ExceptionUtils.getRootCause((Throwable)errorException);
            }
            if (rootCause != null && StringUtils.isNotBlank((String)rootCause.getMessage())) {
                exceptionMessage = exceptionMessage.concat(String.format(": %s", rootCause.getMessage()));
            }
            String msg = String.format("Using route '%s' to service '%s' for request '%s' failed.\nStatus code: '%s', Error: '%s'\nCause: %s\nRoot cause: %s", route, serviceId, requestUri, httpStatus, errorMessage, errorException != null ? errorException.toString() : "No exception available in context", rootCause != null ? rootCause.toString() : "N/A");
            log.warn(msg);
            log.debug(msg, (Object)errorException, (Object)rootCause);
            if (ERROR_MESSAGE_TIMEOUT.equals(errorMessage) || this.isGatewayTimeout(errorException) || rootCause != null && this.isGatewayTimeout(rootCause)) {
                return this.errorResponse(HttpStatus.GATEWAY_TIMEOUT, exceptionMessage, requestUri);
            }
            if (this.isServiceUnavailable(errorException) || rootCause != null && this.isServiceUnavailable(rootCause)) {
                return this.errorResponse(HttpStatus.SERVICE_UNAVAILABLE, exceptionMessage, requestUri);
            }
            errorResponseMessage = String.format("Gateway error: '%s' failed: %s", route, exceptionMessage);
        }
        catch (Throwable t) {
            errorResponseMessage = t.toString();
            log.info("Exception, cause: {}", (Object)errorResponseMessage);
        }
        return this.errorResponse(HttpStatus.INTERNAL_SERVER_ERROR, errorResponseMessage, requestUri);
    }

    protected boolean isServiceUnavailable(Throwable throwable) {
        return throwable instanceof ClientException;
    }

    protected boolean isGatewayTimeout(Throwable throwable) {
        return throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException;
    }

    protected ResponseEntity errorResponse(HttpStatus httpStatus, String message, String path) {
        return ResponseEntity.status((HttpStatus)httpStatus).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)ErrorResponse.builder().timestamp(System.currentTimeMillis()).status(httpStatus.value()).error(httpStatus.getReasonPhrase()).message(message).path(path).build());
    }

    protected String getRequestUriFromRequestContext(RequestContext requestContext) {
        if (requestContext != null && requestContext.get((Object)ZUUL_REQUEST_URI) != null) {
            return (String)requestContext.get((Object)ZUUL_REQUEST_URI);
        }
        return "unknown-uri";
    }

    protected HttpStatus getHttpStatusFromRequestContext(RequestContext requestContext) {
        if (requestContext.containsKey((Object)ATTR_ERROR_STATUS_CODE)) {
            return HttpStatus.valueOf((int)((Integer)requestContext.get((Object)ATTR_ERROR_STATUS_CODE)));
        }
        return null;
    }

    protected String getRouteFromRequestContext(RequestContext requestContext) {
        if (requestContext.containsKey((Object)ATTR_PROXY)) {
            return (String)requestContext.get((Object)ATTR_PROXY);
        }
        return "unknown-route";
    }

    protected String getServiceIdFromRequestContext(RequestContext requestContext) {
        if (requestContext.containsKey((Object)ATTR_SERVICE_ID)) {
            return (String)requestContext.get((Object)ATTR_SERVICE_ID);
        }
        return "unknown-service";
    }

    protected Exception getExceptionFromRequestContext(RequestContext requestContext) {
        if (requestContext.containsKey((Object)ATTR_ERROR_EXCEPTION)) {
            return (Exception)requestContext.get((Object)ATTR_ERROR_EXCEPTION);
        }
        return null;
    }

    protected String getErrorMessageFromRequestContext(RequestContext requestContext) {
        if (requestContext != null && requestContext.containsKey((Object)ATTR_ERROR_MESSAGE)) {
            return (String)requestContext.get((Object)ATTR_ERROR_MESSAGE);
        }
        return "No message available";
    }

    protected RequestContext getCurrentContext() {
        return RequestContext.getCurrentContext();
    }

    public String getErrorPath() {
        return ERROR_PATH;
    }
}

