/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.cluster.gateway.resource;

import com.netflix.zuul.context.RequestContext;
import net.smartcosmos.cluster.gateway.domain.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="permitAll()")
public class NotFoundController {
    private static final Logger log = LoggerFactory.getLogger(NotFoundController.class);
    public static final String NOT_FOUND_PATH = "/notFound";
    private static final String REQUEST_URI_KEY = "requestURI";

    @RequestMapping(value={"/notFound/**"})
    public ResponseEntity<?> notFound() {
        HttpStatus status = HttpStatus.NOT_FOUND;
        return ResponseEntity.status((HttpStatus)status).contentType(MediaType.APPLICATION_JSON_UTF8).body((Object)ErrorResponse.builder().timestamp(System.currentTimeMillis()).status(status.value()).error(status.getReasonPhrase()).path(this.getRequestUri()).build());
    }

    private String getRequestUri() {
        RequestContext context = RequestContext.getCurrentContext();
        if (context.containsKey((Object)REQUEST_URI_KEY)) {
            return context.get((Object)REQUEST_URI_KEY).toString();
        }
        return context.getRequest().getServletPath().replace(NOT_FOUND_PATH, "");
    }
}

