/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.cluster.gateway.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;

@Component
public class AuthenticationErrorHandler
extends DefaultResponseErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationErrorHandler.class);
    private static final String JSON_ERROR_DESCRIPTION = "error_description";

    public void handleError(ClientHttpResponse response) throws BadCredentialsException, IOException {
        if (HttpStatus.BAD_REQUEST.equals((Object)response.getStatusCode())) {
            String responseBody = this.getResponseBody(response);
            throw new BadCredentialsException(this.getErrorDescriptionFromBody(responseBody));
        }
        super.handleError(response);
    }

    protected String getResponseBody(ClientHttpResponse response) {
        try {
            InputStream responseBody = response.getBody();
            if (responseBody != null) {
                return new String(FileCopyUtils.copyToByteArray((InputStream)responseBody));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    protected String getErrorDescriptionFromBody(String body) {
        String[] jsonEntries;
        Map<String, String> jsonMap;
        log.debug("Attempt to read error description from response body '{}'", (Object)body);
        if (StringUtils.isNotBlank((CharSequence)body) && (jsonMap = Arrays.stream(jsonEntries = body.replace("{", "").replace("}", "").replace("\"", "").split(",")).filter(entry -> entry.contains(":")).map(entry -> entry.split(":")).collect(Collectors.toMap(stringArray -> stringArray[0], array -> array[1]))).containsKey(JSON_ERROR_DESCRIPTION)) {
            return jsonMap.get(JSON_ERROR_DESCRIPTION);
        }
        return "Invalid username or password";
    }
}

