/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.extension.stormpath;

import javax.validation.Validator;
import net.smartcosmos.annotation.EnableSmartCosmosEvents;
import net.smartcosmos.annotation.EnableSmartCosmosExtension;
import net.smartcosmos.annotation.EnableSmartCosmosMonitoring;
import net.smartcosmos.extension.stormpath.config.ServiceUserAccessSecurityConfiguration;
import net.smartcosmos.extension.stormpath.config.StormpathProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@EnableSmartCosmosExtension
@EnableSmartCosmosEvents
@EnableSmartCosmosMonitoring
@EnableConfigurationProperties(value={StormpathProperties.class})
@Import(value={ServiceUserAccessSecurityConfiguration.class})
public class StormpathService {
    private static final Logger log = LoggerFactory.getLogger(StormpathService.class);

    public static void main(String[] args) {
        new SpringApplicationBuilder(new Object[]{StormpathService.class}).web(true).run(args);
    }

    @Bean
    PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public Validator localValidatorFactoryBean() {
        return new LocalValidatorFactoryBean();
    }
}

