/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.extension.stormpath.auth;

import java.util.ArrayList;
import java.util.Collection;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public interface SmartCosmosServiceUser {
    public static final String SERVICE_USER_ROLE = "ROLE_SMARTCOSMOS_SERVICE_CLIENT";
    public static final Collection<GrantedAuthority> DEFAULT_SERVICE_USER_AUTHORITIES = SmartCosmosServiceUser.defaultServiceUserAuthorities();

    public static Collection<GrantedAuthority> defaultServiceUserAuthorities() {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add((GrantedAuthority)new SimpleGrantedAuthority("hasRole('ROLE_SMARTCOSMOS_SERVICE_CLIENT')"));
        return authorities;
    }

    public static SmartCosmosUser getServiceUser(String username, String password, Collection<GrantedAuthority> authorities) {
        Collection<Object> serviceUserAuthorities = new ArrayList();
        if (authorities == null || authorities.isEmpty()) {
            serviceUserAuthorities = DEFAULT_SERVICE_USER_AUTHORITIES;
        } else {
            serviceUserAuthorities.addAll(authorities);
        }
        return new SmartCosmosUser(null, null, username, password, serviceUserAuthorities);
    }
}

