/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.extension.stormpath.auth.provider;

import java.util.Collection;
import net.smartcosmos.extension.stormpath.auth.SmartCosmosServiceUser;
import net.smartcosmos.extension.stormpath.config.ServiceUserProperties;
import net.smartcosmos.security.user.SmartCosmosUser;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class ServiceUserAccessAuthenticationProvider
implements AuthenticationProvider {
    private static final Class SUPPORTED_AUTHENTICATION = UsernamePasswordAuthenticationToken.class;
    private SecurityProperties.User serviceUser;

    @Autowired
    public ServiceUserAccessAuthenticationProvider(ServiceUserProperties serviceUserProperties) {
        this.serviceUser = serviceUserProperties.getUser();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication == null) {
            throw new InsufficientAuthenticationException("authentication must not be null");
        }
        String username = authentication.getName();
        Object credentials = authentication.getCredentials();
        Object principal = authentication.getPrincipal();
        if (credentials instanceof String) {
            String password = (String)credentials;
            if (StringUtils.equals((String)username, (String)this.serviceUser.getName()) && StringUtils.equals((String)password, (String)this.serviceUser.getPassword())) {
                SmartCosmosUser user = principal instanceof SmartCosmosUser ? (SmartCosmosUser)principal : SmartCosmosServiceUser.getServiceUser(username, password, null);
                Collection authorities = user.getAuthorities();
                return new UsernamePasswordAuthenticationToken((Object)user, credentials, authorities);
            }
            String msg = String.format("Credentials for user '%s' do not match.", authentication.getName());
            throw new BadCredentialsException(msg);
        }
        return null;
    }

    public boolean supports(Class<?> authenticationClass) {
        return SUPPORTED_AUTHENTICATION.equals(authenticationClass);
    }
}

