/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.extension.stormpath.converter;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.smartcosmos.userdetails.domain.UserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class AccountToUserDetailsConverter
implements Converter<Account, UserDetails> {
    private static final Logger log = LoggerFactory.getLogger(AccountToUserDetailsConverter.class);
    public static final String KEY_AUTHORITIES = "authorities";
    public static final String KEY_URN = "urn";

    public UserDetails convert(Account account) {
        return UserDetails.builder().username(account.getUsername()).userUrn(this.getUserUrn(account)).tenantUrn(this.getTenantUrn(account)).authorities(this.getAuthorities(account)).build();
    }

    protected Set<String> getAuthorities(Account account) {
        if (account.getGroups() == null) {
            return Collections.emptySet();
        }
        HashSet<String> authoritiesSet = new HashSet<String>();
        try {
            for (Group group : account.getGroups()) {
                if (!GroupStatus.ENABLED.equals((Object)group.getStatus())) continue;
                authoritiesSet.addAll(this.getAuthoritiesFromCustomData(group.getCustomData()));
            }
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException | UnsupportedOperationException e) {
            String msg = String.format("Unexpected exception when reading authorities from groups for account %s: %s", account, e.getMessage());
            log.warn(msg);
            log.debug(msg, (Throwable)e);
        }
        return authoritiesSet;
    }

    protected String getUserUrn(Account account) {
        return this.getUrnFromCustomData(account.getCustomData());
    }

    protected String getTenantUrn(Account account) {
        Directory directory = account.getDirectory();
        if (directory == null) {
            return "";
        }
        return this.getUrnFromCustomData(directory.getCustomData());
    }

    protected String getUrnFromCustomData(CustomData customData) {
        try {
            if (customData != null && customData.containsKey((Object)KEY_URN) && customData.get((Object)KEY_URN) instanceof String) {
                return (String)customData.get((Object)KEY_URN);
            }
        }
        catch (ClassCastException e) {
            String msg = String.format("Unexpected exception when reading URN from custom data %s: %s", customData, e.getMessage());
            log.warn(msg);
            log.debug(msg, (Throwable)e);
        }
        return "";
    }

    protected Collection<String> getAuthoritiesFromCustomData(CustomData customData) {
        try {
            if (customData != null && customData.containsKey((Object)KEY_AUTHORITIES) && customData.get((Object)KEY_AUTHORITIES) instanceof Collection) {
                return ((Collection)customData.get((Object)KEY_AUTHORITIES)).stream().filter(element -> element != null).map(element -> (String)element).collect(Collectors.toSet());
            }
        }
        catch (ClassCastException e) {
            String msg = String.format("Unexpected exception when reading authorities from custom data %s: %s", customData, e.getMessage());
            log.warn(msg);
            log.debug(msg, (Throwable)e);
        }
        return Collections.emptySet();
    }
}

