/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.extension.stormpath.service;

import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.resource.ResourceException;
import net.smartcosmos.userdetails.domain.UserDetails;
import net.smartcosmos.userdetails.domain.rest.AuthenticateRequest;
import net.smartcosmos.userdetails.service.AuthenticateUserService;
import net.smartcosmos.userdetails.service.UserDetailsService;
import net.smartcosmos.userdetails.util.ResponseEntityFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Service;

@Service
public class AuthenticateUserServiceStormpath
implements AuthenticateUserService {
    private static final Logger log = LoggerFactory.getLogger(AuthenticateUserServiceStormpath.class);
    private final UserDetailsService stormpathService;

    @Autowired
    public AuthenticateUserServiceStormpath(UserDetailsService stormpathService) {
        this.stormpathService = stormpathService;
    }

    public ResponseEntity<?> authenticateUser(AuthenticateRequest request) {
        log.debug("Requested information on username {} with {}", (Object)request.getName(), (Object)request);
        try {
            UserDetails entity = this.stormpathService.getUserDetails(request.getName(), request.getCredentials());
            if (this.stormpathService.isValid(entity)) {
                log.info("Validation of authentication response for user {} : valid", (Object)request.getName());
                return ResponseEntityFactory.success((UserDetails)entity);
            }
            log.info("Validation of authentication response for user {} : invalid", (Object)request.getName());
            return ResponseEntityFactory.invalidDataReturned();
        }
        catch (AuthenticationServiceException e) {
            log.info("Authenticating user {} failed. Request was {}. Exception: {}", new Object[]{request.getName(), request, e.toString()});
            return ResponseEntityFactory.errorResponse((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (Integer)1, (String)e.getMessage());
        }
        catch (AuthenticationException e) {
            log.info("Authenticating user {} failed. Request was {}. Exception: {}", new Object[]{request.getName(), request, e.toString()});
            if (e.getCause() instanceof ResourceException) {
                Error stormpathError = ((ResourceException)e.getCause()).getStormpathError();
                log.debug("Stormpath returned error: {}", (Object)stormpathError);
                return ResponseEntityFactory.invalidUsernameOrPassword();
            }
            return ResponseEntityFactory.errorResponse((HttpStatus)HttpStatus.BAD_REQUEST, (Integer)1, (String)e.getMessage());
        }
    }

    public ResponseEntity<?> isUserActive(String username) {
        log.debug("Requested information on username {} ", (Object)username);
        try {
            UserDetails userDetails = this.stormpathService.getUserDetails(username);
            if (this.stormpathService.isValid(userDetails)) {
                log.info("Validation of authentication response for user {} : valid", (Object)username);
                return ResponseEntityFactory.success((UserDetails)userDetails);
            }
            log.info("Validation of authentication response for user {} : invalid", (Object)username);
            return ResponseEntityFactory.invalidDataReturned();
        }
        catch (AuthenticationServiceException e) {
            log.info("Authenticating user {} failed. Exception: {}", (Object)username, (Object)e.toString());
            return ResponseEntityFactory.errorResponse((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR, (Integer)1, (String)e.getMessage());
        }
        catch (AuthenticationException e) {
            log.info("Authenticating user {} failed (no longer active?). Exception: {}", (Object)username, (Object)e.toString());
            return ResponseEntityFactory.invalidUsernameOrPassword();
        }
    }
}

