/*
 * Decompiled with CFR 0.152.
 */
package net.smartcosmos.extension.stormpath.service;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.account.AccountStatus;
import com.stormpath.sdk.account.Accounts;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.authc.UsernamePasswordRequests;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.directory.DirectoryStatus;
import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.query.Criterion;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Set;
import javax.validation.Validator;
import net.smartcosmos.extension.stormpath.config.StormpathProperties;
import net.smartcosmos.extension.stormpath.util.StormpathInitializer;
import net.smartcosmos.userdetails.domain.UserDetails;
import net.smartcosmos.userdetails.service.UserDetailsService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsServiceStormpath
implements UserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(UserDetailsServiceStormpath.class);
    private Application application = null;
    private final ConversionService conversionService;
    private final PasswordEncoder passwordEncoder;
    private final StormpathProperties stormpathProperties;
    private final Validator validator;

    @Autowired
    public UserDetailsServiceStormpath(StormpathProperties stormpathProperties, ConversionService conversionService, PasswordEncoder passwordEncoder, Validator validator) {
        this.conversionService = conversionService;
        this.passwordEncoder = passwordEncoder;
        this.stormpathProperties = stormpathProperties;
        this.validator = validator;
        this.initialize();
    }

    public UserDetails getUserDetails(String username, String password) throws IllegalArgumentException, AuthenticationException {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)username), (String)"username may not be blank");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)password), (String)"password may not be blank");
        if (this.isInitialized()) {
            log.debug("Stormpath is attempting to authenticate user {}...", (Object)username);
            AuthenticationRequest request = UsernamePasswordRequests.builder().setUsernameOrEmail(username).setPassword(password).build();
            try {
                AuthenticationResult result = this.application.authenticateAccount(request);
                Account account = result.getAccount();
                log.info("Stormpath has successfully authenticated user {}", (Object)username);
                log.debug("Details for account {}: {}", (Object)username, (Object)account);
                UserDetails userResponse = (UserDetails)this.conversionService.convert((Object)account, UserDetails.class);
                userResponse.setPasswordHash(this.passwordEncoder.encode((CharSequence)password));
                return userResponse;
            }
            catch (ResourceException e) {
                String message = String.format("Stormpath authentication request or user %s failed: %s", username, e.toString());
                log.info(message);
                log.debug(message, (Throwable)e);
                this.throwAuthenticationExceptionForError(message, e);
            }
        }
        log.error("Stormpath application is not initialized");
        throw new InternalAuthenticationServiceException("Stormpath application could not be initialized");
    }

    public UserDetails getUserDetails(String username) throws IllegalArgumentException, AuthenticationException {
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)username), (String)"username may not be blank");
        if (this.isInitialized()) {
            AccountCriteria accountCriteria = Accounts.where((Criterion)Accounts.email().eqIgnoreCase(username));
            AccountList accountList = this.application.getAccounts(accountCriteria);
            if (accountList == null || accountList.getSize() == 0) {
                String msg = String.format("Unable to locate username '%s'", username);
                log.info(msg);
                throw new UsernameNotFoundException(msg);
            }
            if (accountList.getSize() > 1) {
                String msg = String.format("No unique result for username '%s'", username);
                log.info(msg);
                log.debug("Stormpath returned account list {}", (Object)accountList);
                throw new AuthenticationServiceException(msg);
            }
            Account account = (Account)accountList.single();
            if (!AccountStatus.ENABLED.equals((Object)account.getStatus()) || !DirectoryStatus.ENABLED.equals((Object)account.getDirectory().getStatus())) {
                String msg = String.format("Account or directory for username '%s' is disabled", username);
                log.info(msg);
                throw new DisabledException(msg);
            }
            log.info("Stormpath has successfully returned details for user {}", (Object)username);
            log.debug("Details for account {}: {}", (Object)username, (Object)account);
            return (UserDetails)this.conversionService.convert((Object)account, UserDetails.class);
        }
        log.error("Stormpath application is not initialized");
        throw new InternalAuthenticationServiceException("Stormpath application could not be initialized");
    }

    public boolean isValid(UserDetails userDetails) {
        log.debug("Entity: {}", (Object)userDetails);
        Set violations = this.validator.validate((Object)userDetails, new Class[0]);
        log.debug("Constraint violations: {}", (Object)violations.toString());
        return violations.isEmpty();
    }

    public boolean initialize() {
        try {
            String applicationName = this.stormpathProperties.getApplicationName();
            Client stormpathClient = StormpathInitializer.getClientFromProperties(this.stormpathProperties.getApiKey());
            Tenant tenant = stormpathClient.getCurrentTenant();
            this.application = StormpathInitializer.getSingleApplication(tenant, applicationName);
            log.info("Stormpath has successfully initialized application {}", (Object)applicationName);
            log.debug("Details for application {}: {}", (Object)applicationName, (Object)this.application);
        }
        catch (NullPointerException e) {
            log.warn("Initialization of Stormpath service failed. This generally indicates that the Stormpath API key and/or applicationName is missing in the configuration: {}", (Throwable)e);
        }
        return this.application != null;
    }

    private boolean isInitialized() {
        if (this.application == null) {
            log.info("Application is not initialized. Attempting again...");
            if (!this.initialize()) {
                log.error("Initializing failed again. Authentication attempt is aborted.");
            }
        }
        return this.application != null;
    }

    private void throwAuthenticationExceptionForError(String message, ResourceException e) throws AuthenticationException {
        Error error = e.getStormpathError();
        log.info("Stormpath returned error: {}", (Object)error);
        switch (error.getCode()) {
            case 7104: {
                throw new UsernameNotFoundException(message, (Throwable)e);
            }
            case 7100: {
                throw new BadCredentialsException(message, (Throwable)e);
            }
            case 7103: {
                throw new LockedException(message, (Throwable)e);
            }
            case 5101: 
            case 7101: 
            case 7102: 
            case 7105: 
            case 7106: 
            case 7107: {
                throw new DisabledException(message, (Throwable)e);
            }
        }
        throw new AuthenticationServiceException(message, (Throwable)e);
    }
}

