/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import java.util.EventObject;
import snaq.util.ObjectPool;
import snaq.util.Reusable;

public class ObjectPoolEvent<T extends Reusable>
extends EventObject {
    private final Type type;
    private int minPool;
    private int maxPool;
    private int maxSize;
    private long idleTimeout;
    private int checkedOut;
    private int freeCount;
    private int size;
    private float hitRate;

    public ObjectPoolEvent(ObjectPool<T> pool, Type type) {
        super(pool);
        this.type = type;
    }

    public ObjectPool<T> getPool() {
        return (ObjectPool)this.getSource();
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeString() {
        return this.type.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("[source=");
        sb.append(this.source.toString());
        sb.append(",type=");
        sb.append(this.getTypeString());
        sb.append(']');
        return sb.toString();
    }

    public boolean isPoolInitCompleted() {
        return this.type == Type.INIT_COMPLETED;
    }

    public boolean isPoolCheckOut() {
        return this.type == Type.CHECKOUT;
    }

    public boolean isPoolCheckIn() {
        return this.type == Type.CHECKIN;
    }

    public boolean isValidationError() {
        return this.type == Type.VALIDATION_ERROR;
    }

    public boolean isMaxPoolLimitReached() {
        return this.type == Type.MAX_POOL_LIMIT_REACHED;
    }

    public boolean isMaxPoolLimitExceeded() {
        return this.type == Type.MAX_POOL_LIMIT_EXCEEDED;
    }

    public boolean isMaxSizeLimitReached() {
        return this.type == Type.MAX_SIZE_LIMIT_REACHED;
    }

    public boolean isMaxSizeLimitError() {
        return this.type == Type.MAX_SIZE_LIMIT_ERROR;
    }

    public boolean isPoolParametersChanged() {
        return this.type == Type.PARAMETERS_CHANGED;
    }

    public boolean isPoolFlushed() {
        return this.type == Type.POOL_FLUSHED;
    }

    public boolean isPoolReleased() {
        return this.type == Type.POOL_RELEASED;
    }

    void setMinPool(int i) {
        this.minPool = i;
    }

    void setMaxPool(int i) {
        this.maxPool = i;
    }

    void setMaxSize(int i) {
        this.maxSize = i;
    }

    void setIdleTimeout(long i) {
        this.idleTimeout = i;
    }

    void setCheckOut(int i) {
        this.checkedOut = i;
    }

    void setFreeCount(int i) {
        this.freeCount = i;
    }

    void setSize(int i) {
        this.size = i;
    }

    void setPoolHitRate(float f) {
        this.hitRate = f;
    }

    public int getMinPool() {
        return this.minPool;
    }

    public int getMaxPool() {
        return this.maxPool;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getCheckedOut() {
        return this.checkedOut;
    }

    public int getFreeCount() {
        return this.freeCount;
    }

    public int getSize() {
        return this.size;
    }

    public float getPoolHitRate() {
        return this.hitRate;
    }

    public static enum Type {
        INIT_COMPLETED,
        CHECKOUT,
        CHECKIN,
        VALIDATION_ERROR,
        MAX_POOL_LIMIT_REACHED,
        MAX_POOL_LIMIT_EXCEEDED,
        MAX_SIZE_LIMIT_REACHED,
        MAX_SIZE_LIMIT_ERROR,
        PARAMETERS_CHANGED,
        POOL_FLUSHED,
        POOL_RELEASED;

    }
}

