/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import snaq.db.DBPoolDataSource;

public class DBPoolDataSourceFactory
implements ObjectFactory {
    protected static final Logger logger = LoggerFactory.getLogger(DBPoolDataSourceFactory.class);
    private static final AtomicInteger counter = new AtomicInteger(0);

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Enumeration<Object> e;
        if (logger.isDebugEnabled()) {
            logger.debug("Object : " + obj);
            logger.debug("Name   : " + name + (name == null ? "" : " (" + name.getClass().getName() + ")"));
            logger.debug("Context: " + nameCtx);
            if (environment != null) {
                ArrayList list = new ArrayList(environment.keySet());
                Collections.sort(list);
                for (Object o : list) {
                    logger.debug("Environment[" + o + "]: " + environment.get(o));
                }
            }
        }
        if (!(obj instanceof Reference)) {
            return null;
        }
        DBPoolDataSource ds = new DBPoolDataSource();
        if (name != null) {
            StringBuilder sb = new StringBuilder();
            e = name.getAll();
            while (e.hasMoreElements()) {
                sb.append((String)e.nextElement());
            }
            ds.setName(sb.toString());
        } else {
            ds.setName(Integer.toString(counter.getAndIncrement()));
        }
        Reference ref = (Reference)obj;
        e = ref.getAll();
        while (e.hasMoreElements()) {
            RefAddr addr = (RefAddr)e.nextElement();
            String refName = addr.getType();
            String refValue = (String)addr.getContent();
            if (refName.equalsIgnoreCase("description")) {
                ds.setDriverClassName(refValue);
                logger.trace("Set DataSource description: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("user") || refName.equalsIgnoreCase("username")) {
                ds.setUser(refValue);
                logger.trace("Set DataSource username: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("password")) {
                ds.setPassword(refValue);
                logger.trace("Set DataSource password");
                continue;
            }
            if (refName.equalsIgnoreCase("driverClassName")) {
                ds.setDriverClassName(refValue);
                logger.trace("Set DataSource driver class name: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("url")) {
                ds.setUrl(refValue);
                logger.trace("Set DataSource URL: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("passwordDecoderClassName")) {
                ds.setPasswordDecoderClassName(refValue);
                logger.trace("Set DataSource PasswordDecoder class name: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("validatorClassName")) {
                ds.setValidatorClassName(refValue);
                logger.trace("Set DataSource ConnectionValidator class name: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("validationQuery")) {
                ds.setValidationQuery(refValue);
                logger.trace("Set DataSource validation query: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("minPool")) {
                try {
                    ds.setMinPool(Integer.parseInt(refValue));
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
                logger.trace("Set DataSource minPool: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("maxPool")) {
                try {
                    ds.setMaxPool(Integer.parseInt(refValue));
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
                logger.trace("Set DataSource maxPool: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("maxSize")) {
                try {
                    ds.setMaxSize(Integer.parseInt(refValue));
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
                logger.trace("Set DataSource maxSize: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("idleTimeout")) {
                try {
                    ds.setIdleTimeout(Integer.parseInt(refValue));
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
                logger.trace("Set DataSource idleTimeout: " + refValue);
                continue;
            }
            if (refName.equalsIgnoreCase("loginTimeout")) {
                try {
                    ds.setLoginTimeout(Integer.parseInt(refValue));
                }
                catch (NumberFormatException nfx) {
                    throw new NamingException("Invalid '" + refName + "' value: " + refValue);
                }
                logger.trace("Set DataSource loginTimeout: " + refValue);
                continue;
            }
            ds.setConnectionProperty(refName, refValue);
            logger.trace(String.format("Set DataSource property: %s=%s", refName, refValue));
        }
        return ds;
    }
}

