/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

public class TimeWrapper<E> {
    private final E obj;
    private long expiryTime = 0L;
    private long accessed;

    public TimeWrapper(E obj, long expiry) {
        this.obj = obj;
        this.accessed = System.currentTimeMillis();
        if (expiry > 0L) {
            this.expiryTime = this.accessed + expiry;
        }
    }

    public E getObject() {
        return this.obj;
    }

    public synchronized boolean isExpired() {
        return this.expiryTime > 0L && System.currentTimeMillis() > this.expiryTime;
    }

    synchronized void setLiveTime(long expiry) {
        if (expiry < 0L) {
            throw new IllegalArgumentException("Invalid expiry time");
        }
        this.expiryTime = expiry > 0L ? System.currentTimeMillis() + expiry : 0L;
    }

    synchronized void updateAccessed() {
        this.accessed = System.currentTimeMillis();
    }

    synchronized long getAccessed() {
        return this.accessed;
    }
}

