/*
 * Copyright (c) 2014 Snowflake Computing Inc. All right reserved.
 */
package net.snowflake.common.core;


/**
 *
 * @author Johnston Chu
 *
 */
public enum ClientAuthnParameter
{
  // Login name
  LOGIN_NAME,

  // Password
  PASSWORD,

  // SAML Response
  SAML_RESPONSE,
  
  // raw SAML Response
  RAW_SAML_RESPONSE,

  // Account name
  ACCOUNT_NAME,

  // Application identifier.
  CLIENT_APP_ID,

  // Application version.
  CLIENT_APP_VERSION,

  // [Optional] When instructed, the client can send the user's newly selected
  // password.
  CHOSEN_NEW_PASSWORD,

  // Application SVN revision (deprecated, use client_build_id instead)
  SVN_REVISION,

  // Flag that user has accepted license
  LICENSE_ACCEPTED,

  // List of available authentication methods for Duo Security
  EXT_AUTHN_DUO_AVAILABLE_METHODS,

  // External Authentication Method for Duo Security - push or passcode or sms
  EXT_AUTHN_DUO_METHOD,

  // External Authentication passcode - needed if extAuthnMethod is passcode
  PASSCODE,

  // Original session token
  OLD_SESSION_TOKEN,

  // [Optional] Expired master token, if used for token-request with
  // re-authentication
  OLD_MASTER_TOKEN,

  // Type of session token request
  REQUEST_TYPE,

  // Authentication method used to authenticate the current login request
  AUTHENTICATION_METHOD,

  // client build id
  CLIENT_BUILD_ID,

  // client environment
  CLIENT_ENVIRONMENT,
  
  // Re-authentication type
  REAUTHENTICATION_TYPE,
  
  // SAML authentication request id used in the SP initiated flow
  AUTHENTICATION_REQUEST_ID,
  
  // Count to keep track of the number of ping-pong occurrences between 
  // client and GS during a SP initiated federated authentication flow.
  FED_REAUTH_PENDING_COUNT,
  
  // for non-UI client to indicate the authenticator
  AUTHENTICATOR,

  // for non-UI client to indicate the port that the driver is listenning at
  BROWSER_MODE_REDIRECT_PORT,

  // Session parameters
  SESSION_PARAMETERS,

  // JWT token
  JWT_TOKEN,

  // Proof Key
  PROOF_KEY,

  // Token used in authentication
  TOKEN,

  // OAuth Federated CTX Token
  OAUTH_FEDERATED_CTX,

  // Relay State
  RELAY_STATE,
}
