/*
 * Copyright (c) 2012, 2013 Snowflake Computing Inc. All right reserved.
 */
package net.snowflake.common.core;

/**
 * List of components in Global Services.
 *
 * A simple class to describe the different main components in the
 * Global Services. Mainly use to scope parameter settings.
 * Those components are organized in a hierarchy.
 *
 * @author Thierry Cruanes
 */
public enum ComponentEnum
{
  QA(null,               "all things related to QA")
  ,
  GLOBAL_SERVICES(null,               "all the global services")
  ,
    SQL_COMPILER(GLOBAL_SERVICES,     "SQL compiler")
  ,
      SQL_PARSER(SQL_COMPILER,        "SQL parser")
  ,
      QUERY_PLANNER(SQL_COMPILER,     "query planner")
  ,
      CODE_GENERATION(SQL_COMPILER,   "code generation")
  ,
  EXECUTION_PLATFORM(null,            "Execution Platform")
  ;

  private ComponentEnum parent;
  private String        description;

  /**
   * Construct the description of a Global Service component
   * @param parent
   * @param description
   */
  private ComponentEnum(ComponentEnum parent, String description)
  {
    this.parent = parent;
    this.description = description;
  }
}
